VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "HeadOfficeOrder"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"34F5AE6C00A2"
Option Explicit

' $Version: $
' $Auteur: Davids $
' $Date: 16/4/98 10:12a $

Public Function Create(ByVal GarageName As String, ByVal GarageAddress As String, _
                       ByVal GarageTown As String, ByVal GarageState As String, _
                       ByVal GarageZipCode As String, ByVal GarageOrderNumber As Long, _
                       ByVal SalesPerson As String, ByVal CustomerName As String, _
                       ByVal CustomerAddress As String, ByVal CustomerTown As String, _
                       ByVal CustomerState As String, ByVal CustomerZipCode As String, _
                       ByVal CustomerPhone As String, ByVal CarID As Long, _
                       ByVal ColorID As Long, _
                       ByRef OrderNumber As Variant, ByRef DeliveryDate As Variant, _
                       ByRef ReturnValue As Variant, _
                       Optional ConnectionString As Variant) As Boolean
'
' Objet:      cre une commande dans la base de donnes sige
' Arguments:    dtails ordre
' Retours:      True si ordre cr,False sinon
' Auteur:       David Sussman
' Date:         15 Fv 1998

    On Error GoTo Update_Err

    Dim comC        As New ADODB.Command        ' Commande  excuter
    Dim objContext  As ObjectContext            ' contexte objet MTS

    ' obtenir l'objet contexte MTS
    Set objContext = GetObjectContext

    With comC
        ' fixer le type de commande SQL
        If IsMissing(ConnectionString) Then
            .ActiveConnection = RegistryRestore("HeadOffice", "Not Set")
        Else
            .ActiveConnection = ConnectionString
        End If
        .CommandType = adCmdStoredProc
        .CommandText = "usp_OrderInsert"

        ' paramtres
        ' nous n'utilisons pas refresh car cela impliquerait un aller-retour 
	' serveur et nous les crons nous-mme
        With .Parameters
            .Append comC.CreateParameter("@GarageName", adVarChar, adParamInput, 50, GarageName & "")
            .Append comC.CreateParameter("@GarageAddress", adVarChar, adParamInput, 50, GarageAddress & "")
            .Append comC.CreateParameter("@GarageTown", adVarChar, adParamInput, 20, GarageTown & "")
            .Append comC.CreateParameter("@GarageState", adVarChar, adParamInput, 2, GarageState & "")
            .Append comC.CreateParameter("@GarageZipCode", adVarChar, adParamInput, 15, GarageZipCode & "")
            .Append comC.CreateParameter("@GarageOrderNumber", adInteger, adParamInput, 8, GarageOrderNumber)
            .Append comC.CreateParameter("@SalesPerson", adVarChar, adParamInput, 20, SalesPerson & "")
            .Append comC.CreateParameter("@CustomerName", adVarChar, adParamInput, 20, CustomerName & "")
            .Append comC.CreateParameter("@CustomerAddress", adVarChar, adParamInput, 50, CustomerAddress & "")
            .Append comC.CreateParameter("@CustomerTown", adVarChar, adParamInput, 20, CustomerTown & "")
            .Append comC.CreateParameter("@CustomerState", adVarChar, adParamInput, 2, Left$(CustomerState & "", 2))
            .Append comC.CreateParameter("@CustomerZipCode", adVarChar, adParamInput, 15, CustomerZipCode & "")
            .Append comC.CreateParameter("@CustomerPhone", adVarChar, adParamInput, 15, CustomerPhone & "")
            .Append comC.CreateParameter("@CarID", adInteger, adParamInput, 8, CarID)
            .Append comC.CreateParameter("@ColorID", adInteger, adParamInput, 8, ColorID)
            .Append comC.CreateParameter("@OrderNumber", adVarChar, adParamOutput, 10)
            .Append comC.CreateParameter("@DeliveryDate", adDBTimeStamp, adParamOutput, 8)
        End With

        ' lancement de la commande SQL
        .Execute

        ' et lecture paramtres
        OrderNumber = .Parameters("@OrderNumber")
        DeliveryDate = .Parameters("@DeliveryDate")
    End With

    Create = True
    ReturnValue = -1

    ' pour MTS c'est ok
    objContext.SetComplete

Update_Exit:
    ' nettoyage et sortie
    If Not comC Is Nothing Then
        Set comC = Nothing
    End If
    If Not objContext Is Nothing Then
        Set objContext = Nothing
    End If
    Exit Function

Update_Err:
    Create = False

    ' si c'est une erreur "stock insuffisant" pas d'erreur,
    ' seulement renvoi d'un code de retour et chec
    If comC.ActiveConnection.Errors(0).NativeError = 50001 Then
        ReturnValue = 50001
    Else
        Err.Raise Err.Number, "WWCCHOOrder.Create", Err.Description
    End If

    ' pour MTS, non OK
    objContext.SetAbort
    
    Resume Update_Exit

End Function

