VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "ShowroomOrder"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"34F5AED30168"
Option Explicit

' $Version: $
' $Auteur: Davids $
' $Date: 16/4/98 10:07a $

Public Function Create(ByVal CarID As Variant, ByVal ColorID As Variant, ByVal SalesPerson As Variant, PricePaid As Currency, ByVal CustomerName As Variant, ByVal CustomerAddress As Variant, ByVal CustomerTown As Variant, ByVal CustomerState As Variant, ByVal CustomerZipCode As Variant, ByVal CustomerPhone As Variant, ByRef OrderID As Variant, Optional ConnectionString As Variant) As Boolean
'
' Objet:      Cre une commande dans la base de donne concessionnaire
' Arguments:    drails de la commande
' Retours:      True si la commande est cre, False sinon
' Auteur:       David Sussman
' Date:         15 Fv 1998

    On Error GoTo Create_Err

    Dim objCommand          As New ADODB.Command    ' Commande  excuter
    Dim objContext          As ObjectContext        ' Objet contexte MTS
    
    ' obtenir l'objet contexte MTS
    Set objContext = GetObjectContext
    
    With objCommand
        ' fixer le type de commande SQL
        If IsMissing(ConnectionString) Then
            .ActiveConnection = RegistryRestore("Showroom", "Not Set")
        Else
            .ActiveConnection = ConnectionString
        End If
        .CommandType = adCmdStoredProc
        .CommandText = "usp_OrderInsert"
        
        ' obtenir les paramtres
        ' on peut le faire ici car le serveur est local
        .Parameters.Refresh

        ' fixer les paramtres
        .Parameters("@CarID").Value = CarID
        .Parameters("@ColorID").Value = ColorID
        .Parameters("@SalesPerson").Value = SalesPerson & ""
        .Parameters("@PricePaid").Value = PricePaid
        .Parameters("@Name").Value = CustomerName & ""
        .Parameters("@Address").Value = CustomerAddress & ""
        .Parameters("@Town").Value = CustomerTown & ""
        .Parameters("@State").Value = Left$(CustomerState & "", 2)
        .Parameters("@ZipCode").Value = CustomerZipCode & ""
        .Parameters("@Phone").Value = CustomerPhone & ""

        ' lancer la commande SQL
        .Execute

        ' and set the order number
        OrderID = .Parameters("@OrderNumber")
    End With

    Create = True

    ' pour MTS c'est OK
    objContext.SetComplete

Create_Exit:
    ' mnage et fin
    If Not objCommand Is Nothing Then
        Set objCommand = Nothing
    End If
    If Not objContext Is Nothing Then
        Set objContext = Nothing
    End If

    Exit Function

Create_Err:
    Create = False
    OrderID = -1

    ' pour MTS,ce n'est pas OK
    objContext.SetAbort

    Err.Raise Err.Number, "WCCSROrder.Create", Err.Description
    Resume Create_Exit

End Function

'##ModelId=34F5AEDA00C8
Public Function UpdateHODetails(ByVal OrderID As Variant, ByVal HOOrderNumber As Variant, ByVal DeliveryDate As Variant, Optional ConnectionString As Variant) As Boolean
'
' Objet:      met  jour la commande avec le numro de commande usine
'               et le jour de livraison
' Arguments:    OrderID         no commande
'               HOOrderNumber   no commande usine
'               DeliveryDate    date livraison
' Retours:      vrai si MAJ, False sinon
' Auteur:       David Sussman
' Date:         15 Fv 1998

    On Error GoTo UpdateHODetails_Err

    Dim objCommand          As New ADODB.Command    ' Commande SQL  excuter
    Dim objContext          As ObjectContext        ' objet contexte MTS

    ' obtenir l'objet contexte MTS
    Set objContext = GetObjectContext

    With objCommand
        ' fixer le type de commande SQL
        If IsMissing(ConnectionString) Then
            .ActiveConnection = RegistryRestore("Showroom", "Not Set")
        Else
            .ActiveConnection = ConnectionString
        End If
        .CommandType = adCmdStoredProc
        .CommandText = "usp_OrderUpdate"
        ' obtenir les paramtres
        ' on peut le faire ici car le serveur est local

        .Parameters.Refresh

         ' fixer les paramtres
        .Parameters("@OrderID").Value = OrderID
        .Parameters("@HOOrderNumber").Value = HOOrderNumber
        .Parameters("@DeliveryDate").Value = DeliveryDate

        ' lancer la commande SQL
        .Execute
    End With

    UpdateHODetails = True

    ' pour MTS c'est OK
    objContext.SetComplete

UpdateHODetails_Exit:
    ' mnage et fin
    If Not objCommand Is Nothing Then
        Set objCommand = Nothing
    End If
    If Not objContext Is Nothing Then
        Set objContext = Nothing
    End If
    Exit Function

UpdateHODetails_Err:
    UpdateHODetails = False
           
    ' pour MTS,ce n'est pas OK
    objContext.SetAbort

    Err.Raise Err.Number, "WCCSROrder.UpdateHODetails", Err.Description
    Resume UpdateHODetails_Exit

End Function
