VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Begin VB.Form frmMonitor 
   Caption         =   "OrderResponse"
   ClientHeight    =   2415
   ClientLeft      =   195
   ClientTop       =   660
   ClientWidth     =   7935
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   2415
   ScaleWidth      =   7935
   Begin MSFlexGridLib.MSFlexGrid grdOrders 
      Height          =   2175
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   7695
      _ExtentX        =   13573
      _ExtentY        =   3836
      _Version        =   327680
      Cols            =   6
      FixedCols       =   0
      GridLines       =   0
      SelectionMode   =   1
      AllowUserResizing=   1
   End
End
Attribute VB_Name = "frmMonitor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'------------------------------------------------------------------------
' Objet:      Contrle la validation des commandes et la file des rponses
'               et met  jour la grille des ordres et des statuts
' Classes utilises:    Wrox Car Order Monitoring
' References:   Microsoft ActiveX Data Objects
'               MSFlexGrid
'------------------------------------------------------------------------

' colonnes
Private Enum GridColumn
    mconColOrderNumber = 0
    mconColDateSent = 1
    mconColAck = 2
    mconColHOOrder = 3
    mconColDelivery = 4
End Enum

' l'objet suivi de commande
Private WithEvents objMonitor       As WCCOrderMonitorQ.OrderMonitorQ
Attribute objMonitor.VB_VarHelpID = -1

Private Sub Form_Load()
'
' Objet:      initialisation de la forme
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    ' tablit la grille et montre les commandes en cours
    GridInitialise
    GridResize
    ShowOrders

    ' dmarre le suivi
    Set objMonitor = New WCCOrderMonitorQ.OrderMonitorQ

End Sub

Private Sub Form_Resize()
'
' Objet:      Retaille la grille pour suivre la taille de la forme
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    GridResize

End Sub

Private Sub Form_Unload(Cancel As Integer)

    Set objMonitor = Nothing
    
End Sub

Private Sub objMonitor_OrderAck(OrderNumber As Long, Class As Long)
'
' Objet:      met  jour la grille avec les donnes de validation
' Arguments:    OrderNumber     numro de commande
'               Class           la classe du message de valisation
' Returns:      none
' Auteur:       David Sussman
' Date:         17 Mars 1998
' Note:         Le suivi de commande gnre cet venement si un message
'               arrive dans la file

    ' MAJ colonne
    SetGridCell OrderNumber, mconColAck, "Acknowledged"

End Sub

Private Sub objMonitor_OrderResponse(OrderNumber As Long, DeliveryDate As String, HOOrderNumber As String)
'
' Objet:      Met  jour la grille avec un numro de  commande
' Arguments:    OrderNumber     le numro du concessionnaire
'               DeliveryDate    la date de livraison (peut contenir "hors stock")
'               HOOrderNumber   numro d'ordre sige
' Retours:
' Auteur:       David Sussman
' Date:         17 Mars 1998
' Note:         l'objet suivi de commande met cet vnement quand un message
'               arrive dans la file Reponse

    ' MAJ date livraison et numro de commande sige
    SetGridCell OrderNumber, mconColDelivery, Format$(DeliveryDate, "Short Date")
    SetGridCell OrderNumber, mconColHOOrder, HOOrderNumber

End Sub

Public Sub OrderSent(OrderNumber As Long)
'
' Objet:      MAJ grille avec la nouvelle commande
' Arguments:    OrderNumber     le numro de commande concessionnaire
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998
' Note:         Ceci n'est pas trait par l'objet suivi de commande car nous ne
'               pouvons pas garantir que la commande sera retire de la file
'               par le sige avant que nous la voyons. Cependant, comme nous savons
'               que nous venons de crer une commande, nous pouvons le faire nous-mme

    ' ajout d'une nouvelle commande
    grdOrders.AddItem OrderNumber
    SetGridCell OrderNumber, mconColDateSent, Format$(Date, "Short Date")

End Sub

Private Sub GridResize()
'
' Objet:      retaille la grille en gardant les ratios des colonnes existants
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    Dim intCol              As Integer      ' colonne courante
    Dim intRatio            As Integer      ' largeur grille
    Dim adblRatio(5)        As Double       ' ratios

    With grdOrders
        ' sauver les ratios
        For intCol = 0 To .Cols - 1
            adblRatio(intCol) = .ColWidth(intCol) / .Width
        Next

        ' fixer hauteur x largeur -  la taille de la forme
        .Top = 0
        .Left = 0
        .Width = Me.Width
        .Height = Me.Height
        
        ' fixe les largeurs de colonnes, sans tenir compte des ratios existants
        For intCol = 0 To .Cols - 1
            .ColWidth(intCol) = .Width * adblRatio(intCol)
        Next
    End With

End Sub

Private Sub ShowOrders()
'
' Objet:      afficher les ordres existants, qui doivent tre confirms.
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mar 1998
' Note:         Ici je n ai pas employ une mthode d'objet mtier

    Dim recR        As New ADODB.Recordset      ' enregistrements non confirms
    Dim lngOrderID  As Long                     ' no commande concessionnaire
    Dim strAck      As String                   ' string validation

    ' obtenir une liste des commandes en cours
    recR.Open "usp_OrdersNotConfirmed", RegistryRestore("Showroom", "Not Set"), adOpenForwardOnly, adLockReadOnly, adCmdStoredProc

    ' boucle sur les commandes
    While Not recR.EOF
        lngOrderID = recR("OrderID")

        ' test si valid
        If IsNull(recR("Acknowledged")) Then
            strAck = ""
        Else
            strAck = "Acknowledged"
        End If

        ' ajout commande  la grille
        grdOrders.AddItem lngOrderID
        SetGridCell lngOrderID, mconColDateSent, Format$(recR("OrderDate"), "Short Date")
        recR.MoveNext
    Wend

    recR.Close
    Set recR = Nothing

End Sub

Private Function GetGridRow(lngOrderID As Long) As Long
'
' Objet:      trouver la ligne de la grille o se trouve une commande
' Arguments:    intOrderID      numro de commande cherch
' Retours:      ligne de la commande
' Auteur:       David Sussman
' Date:         17 Mars 1998

    Dim intIdx      As Long

    For intIdx = 1 To grdOrders.Rows - 1
        If GridCellContents(intIdx, mconColOrderNumber) = lngOrderID Then
            GetGridRow = intIdx
            Exit Function
        End If
    Next

End Function

Private Function GridCellContents(ByVal lngRow As Integer, ByVal lngColumn As GridColumn) As Variant
'
' Objet:      Retourne le contenu d'une cellule
' Arguments:    lngRow      ligne
'               lngColumn   Colonne
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    With grdOrders
        GridCellContents = .TextArray(lngRow * .Cols + lngColumn)
    End With

End Function

Private Sub SetGridCell(ByVal OrderNumber As Long, ByVal Column As GridColumn, ByVal Value As Variant)
'
' Objet:      MAJ d'une cellule
' Arguments:    OrderNumber     No commande
'               Column          Colonne  modifier
'               Value           nouveau contenu
' Returns:      none
' Author:       David Sussman
' Date:         17 Mars 1998

    Dim intIdx      As Integer

    intIdx = GetGridRow(OrderNumber)

    grdOrders.TextArray(intIdx * grdOrders.Cols + Column) = Value

End Sub

Private Sub GridInitialise()
'
' Objet:        initialise la grille
' Arguments:    aucun
' Retour:       aucunnone
' Auteur:       David Sussman
' Date:         17 Mars 1998

    Dim intCol      As Integer      ' colonnes

    With grdOrders
        ' fixer les donnes initiales
        .Clear
        .Rows = 1
        .Cols = 5
        .FormatString = "<No commande|^Date Envoi|^Valid|<Commande sige|Date livraison"
        .Top = 0
        .Left = 0
        .Width = Me.Width
        .Height = Me.Height

        ' largeur initiale des colonnes
        For intCol = 0 To .Cols - 1
            .ColWidth(intCol) = .Width / .Cols
        Next
    End With

End Sub
