VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "MSFLXGRD.OCX"
Begin VB.Form frmNewOrders 
   Caption         =   "NewOrder"
   ClientHeight    =   6105
   ClientLeft      =   1215
   ClientTop       =   1545
   ClientWidth     =   8775
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   6105
   ScaleWidth      =   8775
   Begin MSFlexGridLib.MSFlexGrid grdOrders 
      Height          =   3735
      Left            =   120
      TabIndex        =   3
      Top             =   120
      Width           =   8535
      _ExtentX        =   15055
      _ExtentY        =   6588
      _Version        =   327680
      Cols            =   6
      FixedCols       =   0
      GridLines       =   0
      SelectionMode   =   1
      AllowUserResizing=   1
   End
   Begin VB.CommandButton cmdUpdate 
      Caption         =   "&Modifier"
      Enabled         =   0   'False
      Height          =   375
      Left            =   4680
      TabIndex        =   2
      Top             =   5520
      Width           =   1455
   End
   Begin VB.TextBox txtDeliveryDate 
      Height          =   285
      Left            =   3000
      TabIndex        =   1
      Top             =   5520
      Width           =   1455
   End
   Begin VB.Label lblDeliveryDate 
      Caption         =   "Date livraison:"
      Height          =   255
      Left            =   1560
      TabIndex        =   0
      Top             =   5520
      Width           =   1215
   End
End
Attribute VB_Name = "frmNewOrders"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'------------------------------------------------------------------------
'
' Objet:      Cre et suit les les commandesMonitor and create incoming orders from showrooms
' Classes utilises: Wrox Car String Bag
'               Wrox Car Co Order Processing
' References:   Microsoft Message Queue Server
'               Microsoft ActiveX Data Objects
'------------------------------------------------------------------------

Private queNewOrder             As MSMQQueue        ' file des commandes
Private WithEvents evtNewOrder  As MSMQEvent        ' evnements
Attribute evtNewOrder.VB_VarHelpID = -1

' colonnes
Private Enum GridColumn
    mconColOrderID = 0
    mconColGarage = 1
    mconColGarageOrderNo = 2
    mconColHOOrderNo = 3
    mconColDateOrdered = 4
    mconColDeliveryDate = 5
    mconColResponseQueue = 6
End Enum

Private Const mconBorderwidth       As Long = 220

Private Sub cmdUpdate_Click()
'
' Objet:    MAJ commande avec la nouvelle date de livraison
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    Dim objOrder            As WCCOrderProcessQ.Process     ' Object traitement commande
    Dim intIdx              As Integer                      ' ligne courante
    Dim lngOrderID          As Long                         ' Order ID
    Dim strResponse         As String                       ' file rponse
    Dim strHOOrderNumber    As String                       ' no commande sige
    Dim strDate             As String                       ' date livraison

    If Not IsDate(txtDeliveryDate) Then
        MsgBox "Date invalide", , "Erreur Date"
        Exit Sub
    End If
        
    ' obtenir le no de commande
    intIdx = grdOrders.Row
    lngOrderID = GridCellContents(intIdx, mconColOrderID)
    strHOOrderNumber = GridCellContents(intIdx, mconColHOOrderNo)
    strDate = Format$(txtDeliveryDate, "Short Date")

    ' lecture dtails file rponse
    strResponse = GridCellContents(intIdx, mconColResponseQueue)

    ' MAJ date livraison
    Set objOrder = CreateObject("WCCOrderProcessQ.Process")
    objOrder.UpdateDeliveryDate lngOrderID, strDate
    SetGridCell lngOrderID, mconColDeliveryDate, strDate
    
    Set objOrder = Nothing

    ' envoi message vers concessionnaire
    RespondToOrder strResponse, GridCellContents(intIdx, mconColGarageOrderNo), strDate, strHOOrderNumber

End Sub

Private Sub evtNewOrder_Arrived(ByVal Queue As Object, ByVal Cursor As Long)
'
' Objet:      Une nouvelle commande est arrive
' Arguments:    Queue       la file MSMQQueue
'               Cursor      position courante dans la queue
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    Dim msgReceived     As New MSMQMessage      ' message reu

    ' extrait le message de la file et le traite
    Set msgReceived = Queue.Receive

    ProcessOrder msgReceived

    ' rtablit le suivi
    queNewOrder.EnableNotification evtNewOrder

End Sub

Private Sub Form_Load()
'
' Objet:      charge les dtails
' Arguments:    aucun
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    ' cration file et objets vnements
    Set queNewOrder = New MSMQQueue
    Set evtNewOrder = New MSMQEvent
    
    ' ouverture file et dmarre la notification
    Set queNewOrder = MessageQueueOpen("NewOrder", MQ_RECEIVE_ACCESS)
    queNewOrder.EnableNotification evtNewOrder

    ' set up the grids
    GridInitialise
    GridResize
    OrdersNotConfirmed

End Sub

Private Sub ProcessOrder(ByVal msgRec As MSMQMessage)
'
' Objet:      traitement d'une commande
' Arguments:    msgRec      message MSMQMessage reu
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    Dim clsStringBag        As New WroxStringBag.StringBag      ' string bag
    Dim objOrder            As WCCOrderProcessQ.Process         ' objet traitement de commande

    Dim strOrderNumber      As String       ' no commande
    Dim strDeliveryDate     As String       ' date livraison
    Dim lngOrderID          As Long         ' id. commande
    Dim lngInStock          As Long         ' quantit en stock

    ' dgroupage des donnes
    clsStringBag.DeSerialize msgRec.Body

    ' notification de la feuille des nouvelles commandes
    frmMonitor.OrderSent msgRec.AppSpecific

    ' cration de la commande locale
    Set objOrder = CreateObject("WCCOrderProcessQ.Process")
    objOrder.Create clsStringBag.Item("GarageName"), _
                    clsStringBag.Item("GarageAddress"), _
                    clsStringBag.Item("GarageTown"), _
                    clsStringBag.Item("GarageState"), _
                    clsStringBag.Item("GarageZipCode"), _
                    msgRec.AppSpecific, _
                    clsStringBag.Item("SalesPerson"), _
                    clsStringBag.Item("CustomerName"), _
                    clsStringBag.Item("CustomerAddress"), _
                    clsStringBag.Item("CustomerTown"), _
                    clsStringBag.Item("CustomerState"), _
                    clsStringBag.Item("CustomerZipCode"), _
                    clsStringBag.Item("CustomerPhone"), _
                    CLng(clsStringBag.Item("CarID")), _
                    CLng(clsStringBag.Item("ColorID")), _
                    msgRec.ResponseQueueInfo.FormatName, _
                    strOrderNumber, strDeliveryDate, _
                    lngOrderID, lngInStock
    Set objOrder = Nothing

    ' MAJ affichage
    If lngInStock < 0 Then
        strDeliveryDate = "hors stock"
    End If
    GridAddRow lngOrderID, _
               clsStringBag.Item("GarageName"), _
               msgRec.AppSpecific, _
               strOrderNumber, _
               Format$(Now, "Short Date"), _
               Format$(strDeliveryDate, "Short Date"), _
               msgRec.ResponseQueueInfo.FormatName

    ' rponse  la commande
    RespondToOrder msgRec.ResponseQueueInfo.FormatName, msgRec.AppSpecific, strDeliveryDate, strOrderNumber
    
End Sub

Private Sub RespondToOrder(strFormatName As String, lngAppSpecific As Long, strLabel As String, strBody As String)
'
' Objet:      traitement d'une commande
' Arguments:    strFormatName       la variable FormatName de la file rponse
'               lngAppSpecific      la proprit AppSpecific du message - l'id. concessionnaire
'               strLabel            la proprit Label (tiquette) du message - la date de livraison
'               strBody             La proprit Body (corps) du message - le no de commande sige
' Retours:      aucun
' Auteur:       David Sussman
' Date:         17 Mars 1998

    Dim infResponse         As New MSMQQueueInfo    ' infos file rponse
    Dim queResponse         As New MSMQQueue        ' file rponse
    Dim msgResponse         As New MSMQMessage      ' message rponse

    ' ouverture de la file rponse
    infResponse.FormatName = strFormatName
    Set queResponse = infResponse.Open(MQ_SEND_ACCESS, MQ_DENY_NONE)

    ' construction de la rponse
    msgResponse.AppSpecific = lngAppSpecific
    msgResponse.Label = strLabel
    msgResponse.Body = strBody

    ' envoi rponse
    msgResponse.Send queResponse, MQ_NO_TRANSACTION

    queResponse.Close
    Set infResponse = Nothing
    Set msgResponse = Nothing
    Set queResponse = Nothing

End Sub

Private Sub Form_Resize()
'
' objet:      retailler la grille
' Arguments:    aucun
' retours:      aucun
' auteur:       David Sussman
' Date:         17 Mar 1998

    ' retailler la grille
    GridResize

    ' garder le texte, zone saisie, et boutons en vue
    lblDeliveryDate.Top = Me.ScaleHeight - lblDeliveryDate.Height - mconBorderwidth
    txtDeliveryDate.Top = Me.ScaleHeight - txtDeliveryDate.Height - mconBorderwidth
    cmdUpdate.Top = Me.ScaleHeight - cmdUpdate.Height - mconBorderwidth

    cmdUpdate.Left = Me.ScaleWidth - cmdUpdate.Width - mconBorderwidth
    txtDeliveryDate.Left = cmdUpdate.Left - txtDeliveryDate.Width - mconBorderwidth
    lblDeliveryDate.Left = txtDeliveryDate.Left - lblDeliveryDate.Width - mconBorderwidth

End Sub


Private Sub OrdersNotConfirmed()
'
' objet:      Lecture des commandes non confirmes - la grille en est remplie au dmarrage
' Arguments:    aucun
' retours:      aucun
' auteur:       David Sussman
' Date:         17 Mars 1998
' Note:         ceci pourrait tre une mthode d'objet mtier

    Dim recOrders       As New ADODB.Recordset      ' recordset des commandes pendantes
    Dim lngOrderID      As Long                     ' id. des commandes pendantes
    Dim strResponse     As String                   ' file rponse
    
    ' lecture des commandes
    recOrders.Open "usp_OrdersNotConfirmed", RegistryRestore("HeadOffice", "Not Set"), adOpenForwardOnly, adLockReadOnly, adCmdStoredProc
    
    ' ajout de chaque commande  la grille
    While Not recOrders.EOF
        lngOrderID = recOrders("OrderID")

        If IsNull(recOrders("ResponseQueue")) Then
            strResponse = ""
        Else
            strResponse = recOrders("ResponseQueue")
        End If
            
        GridAddRow lngOrderID, recOrders("GarageName"), _
            recOrders("GarageOrderNumber"), recOrders("HOOrderNumber"), _
            Format$(recOrders("DateOrdered"), "Short Date"), _
            "Hors stock", strResponse

        recOrders.MoveNext
    Wend

    recOrders.Close
    Set recOrders = Nothing

End Sub

Private Sub GridInitialise()
'
' objet:      Initialise la grille
' Arguments:    aucun
' retours:      aucun
' auteur:       David Sussman
' Date:         17 Mars 1998

    With grdOrders
        .Clear
        .Rows = 1
        .Cols = 7
        .FormatString = "<Id. commande|<Garage|>No commande Garage|^No commande sige|^Date commande|^Date livraison|RQ"
        .Width = Me.ScaleWidth - mconBorderwidth
        .Height = cmdUpdate.Top - mconBorderwidth - .Top

        ' tailles des colonness - ignore les colonnes file rponse - c'est cach
        .ColWidth(mconColOrderID) = .Width * 0.08
        .ColWidth(mconColGarage) = .Width * 0.22
        .ColWidth(mconColGarageOrderNo) = .Width * 0.2
        .ColWidth(mconColHOOrderNo) = .Width * 0.18
        .ColWidth(mconColDateOrdered) = .Width * 0.15
        .ColWidth(mconColDeliveryDate) = .Width * 0.15
        .ColWidth(mconColResponseQueue) = 0
    End With

End Sub

Private Sub SetGridCell(ByVal OrderNumber As Long, ByVal Column As GridColumn, ByVal Value As Variant)
'
' objet:      fixe le contenu d'une cellule
' Arguments:    OrderNumber     Numro de commande
'               Column          Colonne  traiter
'               Value           valeur  mettre
' retours:      aucun
' auteur:       David Sussman
' Date:         17 Mars 1998

    Dim intIdx      As Integer      ' la ligne de la commande

    ' chercher la ligne de la commande
    intIdx = GetGridRow(OrderNumber)

    grdOrders.TextArray(intIdx * grdOrders.Cols + Column) = Value

End Sub

Private Function GridCellContents(ByVal lngRow As Integer, ByVal lngColumn As GridColumn) As Variant
'
' objet:      Retrouve le contenu d'une cellule
' Arguments:    lngRow      ligne  observer
'               lngColumn   Colonne  observer
' retours:      Contenu de la cellule
' auteur:       David Sussman
' Date:         17 Mars 1998

    With grdOrders
        GridCellContents = .TextArray(lngRow * .Cols + lngColumn)
    End With

End Function

Private Function GetGridRow(lngOrderID As Long) As Long
'
' objet:      recherche ligne par l'id. de la commande
' Arguments:    lngOrderID     id. commande
' retours:      ligne de la commande
' auteur:       David Sussman
' Date:         17 Mars 1998

    Dim intIdx      As Integer      ' index ligne

    For intIdx = 1 To grdOrders.Rows
        If GridCellContents(intIdx, mconColOrderID) = lngOrderID Then
            GetGridRow = intIdx
            Exit Function
        End If
    Next

End Function

Private Sub GridResize()
'
' objet:        Retaillage grille
' Arguments:    aucun
' retours:      aucun
' auteur:       David Sussman
' Date:         17 Mars 1998

    Dim intCol              As Integer      ' colonne courante
    Dim intRatio            As Integer      ' largeur grille
    Dim adblRatio(6)        As Double       ' ratios

    With grdOrders
        ' sauvegarde des ratios
        For intCol = 0 To .Cols - 2
            adblRatio(intCol) = .ColWidth(intCol) / .Width
        Next

        ' fixer largeur et hauteur de la grille -  la taille de la feuille
        .Width = Me.ScaleWidth - mconBorderwidth
        .Height = cmdUpdate.Top - mconBorderwidth - .Top

        ' fixer les largeurs de colonnes en gardant les ratios existants
        For intCol = 0 To .Cols - 2
            .ColWidth(intCol) = .Width * adblRatio(intCol)
        Next
    End With

End Sub


Private Sub GridAddRow(ByVal lngOrderID As Long, ByVal strGarageName As String, _
                        ByVal lngGarageOrderNumber As Long, _
                        ByVal strHOOrderNumber As String, ByVal strDateOrdered As String, _
                        ByVal strDeliveryDate As String, ByVal strResponse As String)
'
' objet:      Ajout d'une ligne  la grille
' Arguments:    lngOrderID              id. commande
'               strGarageName           nom garage
'               lngGarageOrderNumber    no commande garage
'               strHOOrderNumber        no commande sige
'               strDateOrdered          Date commande
'               strDeliveryDate         Date livraison
'               strResponse             variable FormatName de la file MSMQ rponse
' retours:      aucun
' auteur:       David Sussman
' Date:         17 Mars 1998

    grdOrders.AddItem lngOrderID
    SetGridCell lngOrderID, mconColGarage, strGarageName
    SetGridCell lngOrderID, mconColGarageOrderNo, lngGarageOrderNumber
    SetGridCell lngOrderID, mconColHOOrderNo, strHOOrderNumber
    SetGridCell lngOrderID, mconColDateOrdered, strDateOrdered
    SetGridCell lngOrderID, mconColDeliveryDate, strDeliveryDate
    SetGridCell lngOrderID, mconColResponseQueue, strResponse

End Sub

Private Sub grdOrders_Click()
'
' objet:        activer/dsactiver les options de mise  jour
' Arguments:    aucun
' retours:      aucun
' auteur:       David Sussman
' Date:         17 Mar 1998

    Dim bEnabled        As Boolean      ' vrai si modification autorise

    bEnabled = (GridCellContents(grdOrders.Row, mconColDeliveryDate) = "Hors stock")
        
    lblDeliveryDate.Enabled = bEnabled
    txtDeliveryDate.Enabled = bEnabled
    cmdUpdate.Enabled = bEnabled

End Sub
