VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "HeadOfficeOrderQ"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"34F5AE6C00A2"
Option Explicit

'----------------------------------------------------------------------
'
' But:      Passer commande au fabricant
'           On envoie les donnes de la commande empaquetes dans un message
'           MSMQ.
' Classes employes : Wrox String Bag
' Rfrences:   Microsoft Message Queue Server
'               Microsoft transaction Server
'----------------------------------------------------------------------

Public Function Create(ByVal GarageName As String, ByVal GarageAddress As String, _
                       ByVal GarageTown As String, ByVal GarageState As String, _
                       ByVal GarageZipCode As String, ByVal GarageOrderNumber As Long, _
                       ByVal SalesPerson As String, ByVal CustomerName As String, _
                       ByVal CustomerAddress As String, ByVal CustomerTown As String, _
                       ByVal CustomerState As String, ByVal CustomerZipCode As String, _
                       ByVal CustomerPhone As String, ByVal CarID As Long, _
                       ByVal ColorID As Long) As Boolean
Attribute Create.VB_Description = "Create an order at head office"
'
' But:      Crer un enregistrement pour la commande dans la base de donnes du fabricant
'           par envoi d'un message MSMQ
' Arguments:    les donnes de la commande
' Retours:      True si la cration de l'enregistrement russit, False sinon
' Auteur:       David Sussman
' Date:         12 Mar 1998
' Note:         Les commandes sont places dans une file d'attente

    On Error GoTo Create_Err
    
    Dim objContext      As ObjectContext                ' contexte MTS
    Dim msgOrder        As New MSMQMessage              ' message contenant les donnes de la commande
    Dim queSend         As New MSMQQueue                ' file dans laquelle on envoie les nouvelles commande
    Dim infResponse     As New MSMQQueueInfo            ' file dans laquelle sont envoyes les messages de rponse du fabricant
    Dim infAck          As New MSMQQueueInfo            ' file dans laquelle sont envoyes les acquittements
    Dim objStringBag    As New WroxStringBag.StringBag  ' le "sac  chane" permettant de stocker les proprits
    Dim queTemp         As New MSMQQueue                ' file de message temporaire
    
    ' obtention du contexte MTS pour la transaction en cours
    Set objContext = GetObjectContext
    
    ' ouverture de la file de destination
    Set queSend = MessageQueueOpen(mcstrNewOrder, MQ_SEND_ACCESS)
    
    ' on dfinit les files pour les messages de rponse et d'acquittement
    Set queTemp = MessageQueueOpen(mcstrOrderAck, MQ_RECEIVE_ACCESS)
    infAck.FormatName = queTemp.QueueInfo.FormatName
    queTemp.Close
    
    Set queTemp = MessageQueueOpen(mcstrOrderResponse, MQ_RECEIVE_ACCESS)
    infResponse.FormatName = queTemp.QueueInfo.FormatName
    queTemp.Close
    
    ' on concatne toutes les donnes de la commande dans une chane
    With objStringBag
        .Add "GarageName", GarageName
        .Add "GarageAddress", GarageAddress
        .Add "GarageTown", GarageTown
        .Add "GarageState", GarageState
        .Add "GarageZipCode", GarageZipCode
        .Add "SalesPerson", SalesPerson
        .Add "CustomerName", CustomerName
        .Add "CustomerAddress", CustomerAddress
        .Add "CustomerTown", CustomerTown
        .Add "CustomerState", CustomerState
        .Add "CustomerZipCode", CustomerZipCode
        .Add "CustomerPhone", CustomerPhone
        .Add "CarID", CStr(CarID)
        .Add "ColorID", CStr(ColorID)
    End With
    
    ' Construction du message
    '   Le libell (Label) est form  partir du nom du garage et du numro de la commande
    '   Le corps du message (Body) contient la chane forme en srialisant les proprits de la commande
    '   AppSepcific correspond au numro de commande attribu par le concessionnaire (garage)
    '   La remise (Delivery) est rcuprable (recoverable) au cas o le rseau connaitrait des dfaillances
    '   La proprit Ack spcifie qu'un acquittement soit renvoy ds rception de la nouvelle commande
    '   AdminQueueInfo correspond  la file d'acquittement
    '   ResponseQueueInfo correspond  la file de rponse proprement dite (date de livraison)
    With msgOrder
        .Label = GarageName & ": Order number " & CStr(GarageOrderNumber)
        .Body = objStringBag.Serialize
        .AppSpecific = GarageOrderNumber
        .Delivery = MQMSG_DELIVERY_RECOVERABLE
        .Ack = MQMSG_ACKNOWLEDGMENT_FULL_RECEIVE
        Set .AdminQueueInfo = infAck
        Set .ResponseQueueInfo = infResponse
    End With
    
    ' envoi du message  la file distante
    msgOrder.Send queSend, MQ_MTS_TRANSACTION
    
    ' fermeture de la file
    queSend.Close

    Create = True
    
    ' on indique  MTS que l'opration s'est droul avec succs
    objContext.SetComplete

Create_Exit:
    ' nettoyage et sortie
    If Not objContext Is Nothing Then
        Set objContext = Nothing
    End If
    If Not objStringBag Is Nothing Then
        Set objStringBag = Nothing
    End If
    
    Exit Function

Create_Err:
    
    ' on indique  MTS que l'opration ne s'est pas droule avec succs
    objContext.SetAbort

    Create = False

    Err.Raise Err.Number, "WWCCHOOrderQ.Create", Err.Description
    
    Resume Create_Exit

End Function

