VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "OrderQ"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"34F5AF2C024D"
Option Explicit

' $Revision: 2 $
' $Author: Davids $
' $Date: 4/16/98 3:14p $

'---------------------------------------------------------------------------
' But:      Crer un enregistremennt pour la commande dans les deux bases de donnes
'           (concessionnaire et fabricant)
' Classes employes: Wrox Car Co Showroom Ordering
'                    Wrox Car Co Head Office Ordering
' Rfrences:   Microsoft Transaction Server
'---------------------------------------------------------------------------

Public Function Create(ByVal GarageName As String, ByVal GarageAddress As String, _
                       ByVal GarageTown As String, ByVal GarageState As String, _
                       ByVal GarageZipCode As String, ByVal SalesPerson As String, _
                       ByVal PricePaid As Currency, ByVal CustomerName As String, _
                       ByVal CustomerAddress As String, ByVal CustomerTown As String, _
                       ByVal CustomerState As String, ByVal CustomerZipCode As String, _
                       ByVal CustomerPhone As String, _
                       ByVal CarID As Long, ByVal ColorID As Long, _
                       ByRef ShowroomOrderNumber As Long, _
                       Optional SRConnectionString As Variant) As Boolean
Attribute Create.VB_Description = "Create an order in both showroom and head office"

    On Error GoTo Create_Error

    Dim objContext      As ObjectContext                    ' contexte MTS
    Dim objHOOrder      As WCCHOOrderQ.HeadOfficeOrderQ     ' enregistrement de la commande chez le fabricant
    Dim objSROrder      As WCCSROrderQ.ShowroomOrderQ       ' enregistrement de la commande chez le concessionnaire
    Dim strSROrderID    As String                           ' ID du concessionnaire
    Dim strRV           As String                           ' valeur retourne

    ' obtention du contexte MTS pour initialiser la transaction
    Set objContext = GetObjectContext

    ' cration de l'enregistrement chez le fabricant
    Set objSROrder = objContext.CreateInstance("WCCSROrderQ.ShowroomOrderQ")
    If IsMissing(SRConnectionString) Then
        SRConnectionString = RegistryRestore("Showroom", "Not Set")
    End If
    objSROrder.Create CarID, ColorID, SalesPerson, PricePaid, _
                      CustomerName, CustomerAddress, CustomerTown, _
                      CustomerState, CustomerZipCode, CustomerPhone, _
                      strSROrderID, SRConnectionString

    ' cration de la commande chez le concessionnaire
    Set objHOOrder = objContext.CreateInstance("WCCHOOrderQ.HeadOfficeOrderQ")
    objHOOrder.Create GarageName, GarageAddress, GarageTown, _
                      GarageState, GarageZipCode, strSROrderID, _
                      SalesPerson, CustomerName, CustomerAddress, _
                      CustomerTown, CustomerState, CustomerZipCode, _
                      CustomerPhone, CarID, ColorID

    ' on indique  MTS que l'opration s'est droule avec succs
    objContext.SetComplete
    ShowroomOrderNumber = CLng(strSROrderID)
    Create = True

Create_Exit:
    ' nettoyage et sortie
    If Not objContext Is Nothing Then
        Set objContext = Nothing
    End If
    If Not objHOOrder Is Nothing Then
        Set objHOOrder = Nothing
    End If
    If Not objSROrder Is Nothing Then
        Set objSROrder = Nothing
    End If
    Exit Function

Create_Error:
    ' en cas d'erreur on demande  MTS d'annuler la transaction
    objContext.SetAbort
    Create = False
    ShowroomOrderNumber = 0

    Err.Raise Err.Number, "WCCOrder.Create", Err.Description
    Resume Create_Exit
    
End Function

