VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "ShowroomOrderQ"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"34F5AED30168"

Option Explicit

' $Revision: 2 $
' $Auteur: Davids $
' $Date: 4/16/98 3:14p $

'--------------------------------------------------------------------------
' But:      Cration d'un enregistrement pour la commande dans la base de
'           donnes locale du concessionnaire (ou garage)
' Classes employes: aucune
' Rfrences:   Microsoft Active Data Objects
'               Microsoft transaction Server
'--------------------------------------------------------------------------

Public Function Create(ByVal CarID As Variant, ByVal ColorID As Variant, _
                       ByVal SalesPerson As Variant, PricePaid As Currency, _
                       ByVal CustomerName As Variant, ByVal CustomerAddress As Variant, _
                       ByVal CustomerTown As Variant, ByVal CustomerState As Variant, _
                       ByVal CustomerZipCode As Variant, ByVal CustomerPhone As Variant, _
                       ByRef OrderID As Variant, _
                       Optional ConnectionString As Variant) As Boolean
Attribute Create.VB_Description = "Create an order in the showrrom database"
'
' But:      Cration de l'enregsitrment dans la base de donnes locale du concessionnaire
' Arguments:    les donnes relatives  la commande (ID du modle, ID du coloris, vendeur,...)
' Retours:      True si l'enregistrement peut tre cr, False sinon
' Auteur:       David Sussman
' Date:         12 Mar 1998

    On Error GoTo Create_Err

    Dim objCommand          As New ADODB.Command    ' commande  excuter
    Dim objContext          As ObjectContext        ' contexte MTS
    
    ' obtention du contexte MTS pour la transaction
    Set objContext = GetObjectContext
    
    With objCommand
        ' dfinition du type de la commande ADO
        If IsMissing(ConnectionString) Then
            .ActiveConnection = RegistryRestore("Showroom", "Not Set")
        Else
            .ActiveConnection = ConnectionString
        End If
        .CommandType = adCmdStoredProc
        .CommandText = "usp_OrderInsert"
        
        ' on doit maintenant obtenir les paramtres.
        ' On peut se permettre de la faire directement ici car le serveur est local
        .Parameters.Refresh

        ' on dfinit ensuite la valeur des paramtres
        .Parameters("@CarID").Value = CarID
        .Parameters("@ColorID").Value = ColorID
        .Parameters("@SalesPerson").Value = SalesPerson & ""
        .Parameters("@PricePaid").Value = PricePaid
        .Parameters("@Name").Value = CustomerName & ""
        .Parameters("@Address").Value = CustomerAddress & ""
        .Parameters("@Town").Value = CustomerTown & ""
        .Parameters("@State").Value = Left$(CustomerState & "", 2)
        .Parameters("@ZipCode").Value = CustomerZipCode & ""
        .Parameters("@Phone").Value = CustomerPhone & ""

        ' on peut alors excuter la commande ADO...
        .Execute
        
        ' ...et enfin attribuer  l'enregistrement un numro de commande
        OrderID = .Parameters("@OrderNumber")
    End With
    
    Create = True

    ' on indique  MTS que l'opration s'est droule avec succs
    objContext.SetComplete

Create_Exit:
    ' nettoyage et sortie
    If Not objCommand Is Nothing Then
        Set objCommand = Nothing
    End If
    If Not objContext Is Nothing Then
        Set objContext = Nothing
    End If
    Exit Function

Create_Err:
    Create = False
    OrderID = -1
       
    ' on indique  MTS que l'opration ne s'est pas droule convenablement
    objContext.SetAbort

    Err.Raise Err.Number, "WCCSROrder.Create", Err.Description
    Resume Create_Exit

End Function

Public Function UpdateAck(ByVal OrderID As Variant, Optional ConnectionString As Variant) As Boolean
Attribute UpdateAck.VB_Description = "Update the acknowledged flag for an order"
'
' But :      MAJ de l'enregistrement avec la rfrence attribue par le fabricant pour la commande
' Arguments:    OrderID         ID de l'enregistrement (ou commande)  mettre  jour
' Retours:      True si la MAJ russit, False sinon
' Auteur:       David Sussman
' Date:         12 Mar 1998

    On Error GoTo UpdateAck_Err

    Dim objCommand          As New ADODB.Command    ' Commande ADO  excuter
    Dim objContext          As ObjectContext        ' contexte MTS

    ' obtention du contexte MTS pour la transaction
    Set objContext = GetObjectContext

    With objCommand
        ' on dfinit le type de la commande ADO
        If IsMissing(ConnectionString) Then
            .ActiveConnection = RegistryRestore("Showroom", "Not Set")
        Else
            .ActiveConnection = ConnectionString
        End If
        .CommandType = adCmdStoredProc
        .CommandText = "usp_OrderUpdateAck"

        ' Obtention des paramtres.
        ' Ici on peut les obtenir directement car le serveur est local
        .Parameters.Refresh

        ' On peut ensuite dfinir la valeur des paramtres ...
        .Parameters("@OrderID").Value = OrderID

        ' ... et excuter la commande ADO
        .Execute
    End With

    UpdateAck = True

    ' on indique  MTS que l'opration s'est droule avec succs
    objContext.SetComplete

UpdateAck_Exit:
    ' nettoyage et sortie
    If Not objCommand Is Nothing Then
        Set objCommand = Nothing
    End If
    If Not objContext Is Nothing Then
        Set objContext = Nothing
    End If
    Exit Function

UpdateAck_Err:
    UpdateAck = False
           
    ' on indique  MTS que l'opration a chou
    objContext.SetAbort

    Err.Raise Err.Number, "WCCSROrder.UpdateAck", Err.Description
    Resume UpdateAck_Exit

End Function

Public Function UpdateDelivery(ByVal OrderID As Variant, ByVal HOOrderNumber As Variant, ByVal DeliveryDate As Variant, Optional ConnectionString As Variant) As Boolean
Attribute UpdateDelivery.VB_Description = "Update the head office order number and delivery date"
'
' But:      MAJ de la date de livraison
' Arguments:    OrderID         ID de l'enregistrement (commande)  mettre  jour
'               HOOrderNumber   Rfrence fabricant pour cette commande
'               DeliveryDate    Date prvu pour la livraison du vhicule
' Retours:      True si la MAJ russit, False sinon
' Auteur:       David Sussman
' Date:         12 Mar 1998

    On Error GoTo UpdateDelivery_Err

    Dim objCommand          As New ADODB.Command    ' Commande ADO  excuter
    Dim objContext          As ObjectContext        ' contexte MTS

    ' obtentino du contexte MTS pour la transaction
    Set objContext = GetObjectContext

    With objCommand
        ' on dfinit le type de la commande ADO
        If IsMissing(ConnectionString) Then
            .ActiveConnection = RegistryRestore("Showroom", "Not Set")
        Else
            .ActiveConnection = ConnectionString
        End If
        .CommandType = adCmdStoredProc
        .CommandText = "usp_OrderUpdateDelivery"

        ' Obtention des paramtres.
        ' Ici, on peut les obtenir directement car le serveur est local
        .Parameters.Refresh

        ' On dfinit la valeur des paramtres...
        .Parameters("@OrderID").Value = OrderID
        .Parameters("@HOOrderNumber").Value = HOOrderNumber
        .Parameters("@DeliveryDate").Value = DeliveryDate

        ' ...et on excute la commande ADO
        .Execute
    End With

    UpdateDelivery = True

    ' On indique  MTS que l'opration s'est droule avec succs
    objContext.SetComplete

UpdateDelivery_Exit:
    ' nettoyage et sortie
    If Not objCommand Is Nothing Then
        Set objCommand = Nothing
    End If
    If Not objContext Is Nothing Then
        Set objContext = Nothing
    End If
    Exit Function

UpdateDelivery_Err:
    UpdateDelivery = False
           
    ' on indique  MTS que l'opration a chou
    objContext.SetAbort

    Err.Raise Err.Number, "WCCSROrder.UpdateDelivery", Err.Description
    Resume UpdateDelivery_Exit

End Function
