/* Microsoft SQL Server - Scripting			*/
/* Server: TIGGER					*/
/* Database: WroxCarCoHeadOffice					*/
/* Creation Date 3/26/98 3:18:25 PM 			*/

USE WroxCarCoHeadOffice
GO

/****** Object:  Stored Procedure dbo.usp_OrderInsert    Script Date: 3/26/98 3:18:32 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_OrderInsert') and sysstat & 0xf = 4)
	drop procedure dbo.usp_OrderInsert
GO

/****** Object:  Stored Procedure dbo.usp_OrderInsertQ    Script Date: 3/26/98 3:18:32 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_OrderInsertQ') and sysstat & 0xf = 4)
	drop procedure dbo.usp_OrderInsertQ
GO

/****** Object:  Stored Procedure dbo.usp_OrderUpdateDeliveryDate    Script Date: 3/26/98 3:18:32 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_OrderUpdateDeliveryDate') and sysstat & 0xf = 4)
	drop procedure dbo.usp_OrderUpdateDeliveryDate
GO

/****** Object:  Stored Procedure dbo.usp_OrdersNotConfirmed    Script Date: 3/26/98 3:18:32 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_OrdersNotConfirmed') and sysstat & 0xf = 4)
	drop procedure dbo.usp_OrdersNotConfirmed
GO

/****** Object:  Stored Procedure dbo.usp_StockDecrement    Script Date: 3/26/98 3:18:32 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_StockDecrement') and sysstat & 0xf = 4)
	drop procedure dbo.usp_StockDecrement
GO

/****** Object:  Stored Procedure dbo.usp_StockDecrementQ    Script Date: 3/26/98 3:28:46 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.usp_StockDecrementQ') and sysstat & 0xf = 4)
	drop procedure dbo.usp_StockDecrementQ
GO

/****** Object:  Table dbo.tblCarColor    Script Date: 3/26/98 3:18:32 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.tblCarColor') and sysstat & 0xf = 3)
	drop table dbo.tblCarColor
GO

/****** Object:  Table dbo.tblOrder    Script Date: 3/26/98 3:18:32 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.tblOrder') and sysstat & 0xf = 3)
	drop table dbo.tblOrder
GO

/****** Object:  Table dbo.tblCar    Script Date: 3/26/98 3:18:32 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.tblCar') and sysstat & 0xf = 3)
	drop table dbo.tblCar
GO

/****** Object:  Table dbo.tblColor    Script Date: 3/26/98 3:18:32 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.tblColor') and sysstat & 0xf = 3)
	drop table dbo.tblColor
GO

/****** Object:  Default dbo.UW_ZeroDefault    Script Date: 3/26/98 3:18:32 PM ******/
if exists (select * from sysobjects where id = object_id('dbo.UW_ZeroDefault') and sysstat & 0xf = 6)
	drop default dbo.UW_ZeroDefault
GO

/****** Object:  Default dbo.UW_ZeroDefault    Script Date: 3/26/98 3:18:32 PM ******/
CREATE DEFAULT dbo.UW_ZeroDefault AS 0
GO

/****** Object:  Table dbo.tblCar    Script Date: 3/26/98 3:18:33 PM ******/
CREATE TABLE dbo.tblCar (
	CarID int IDENTITY (1, 1) NOT NULL ,
	Model varchar (50) NULL ,
	EngineSize smallint NULL ,
	Doors smallint NULL ,
	Seats smallint NULL ,
	Price numeric(18, 0) NULL ,
	Picture varchar (255) NULL ,
	Description text NULL ,
	CONSTRAINT aaaaatblCar_PK PRIMARY KEY  NONCLUSTERED 
	(
		CarID
	)
)
GO

 CREATE  INDEX CarID ON dbo.tblCar(CarID)
GO

setuser 'dbo'
GO

EXEC sp_bindefault 'dbo.UW_ZeroDefault', 'tblCar.Doors'
GO

EXEC sp_bindefault 'dbo.UW_ZeroDefault', 'tblCar.EngineSize'
GO

EXEC sp_bindefault 'dbo.UW_ZeroDefault', 'tblCar.Seats'
GO

setuser
GO

GRANT  SELECT  ON tblCar  TO public
GO

/****** Object:  Table dbo.tblColor    Script Date: 3/26/98 3:18:34 PM ******/
CREATE TABLE dbo.tblColor (
	ColorID int IDENTITY (1, 1) NOT NULL ,
	Color varchar (50) NULL ,
	ColorHTM varchar(50) NULL ,
	CONSTRAINT aaaaatblColour_PK PRIMARY KEY  NONCLUSTERED 
	(
		ColorID
	)
)
GO

 CREATE  INDEX ColourID ON dbo.tblColor(ColorID)
GO

GRANT  SELECT  ON tblColor  TO public
GO

/****** Object:  Table dbo.tblCarColor    Script Date: 3/26/98 3:18:34 PM ******/
CREATE TABLE dbo.tblCarColor (
	CarColorID int IDENTITY (1, 1) NOT NULL ,
	fkCarID int NULL ,
	fkColorID int NULL ,
	InStock smallint NULL ,
	OnOrder smallint NULL ,
	CONSTRAINT aaaaatblStock_PK PRIMARY KEY  NONCLUSTERED 
	(
		CarColorID
	),
	CONSTRAINT FK_tblCarColor_tblCar FOREIGN KEY 
	(
		fkCarID
	) REFERENCES dbo.tblCar (
		CarID
	),
	CONSTRAINT FK_tblCarColor_tblColor FOREIGN KEY 
	(
		fkColorID
	) REFERENCES dbo.tblColor (
		ColorID
	)
)
GO

 CREATE  INDEX CarID ON dbo.tblCarColor(CarColorID)
GO

setuser 'dbo'
GO

EXEC sp_bindefault 'dbo.UW_ZeroDefault', 'tblCarColor.InStock'
GO

EXEC sp_bindefault 'dbo.UW_ZeroDefault', 'tblCarColor.OnOrder'
GO

setuser
GO

GRANT  SELECT ,  UPDATE  ON tblCarColor  TO public
GO


/****** Object:  Table dbo.tblOrder    Script Date: 3/26/98 3:18:35 PM ******/
CREATE TABLE dbo.tblOrder (
	OrderID int IDENTITY (1, 1) NOT NULL ,
	GarageName varchar (50) NULL ,
	GarageAddress varchar (50) NULL ,
	GarageTown varchar (20) NULL ,
	GarageState varchar (2) NULL ,
	GarageZipCode varchar (15) NULL ,
	SalesPerson varchar (20) NULL ,
	CustomerName varchar (20) NULL ,
	CustomerAddress varchar (50) NULL ,
	CustomerTown varchar (20) NULL ,
	CustomerState varchar (2) NULL ,
	CustomerZipCode varchar (15) NULL ,
	fkCarID int NOT NULL ,
	DateOrdered datetime NULL ,
	Ackowledged datetime NULL ,
	DeliveryDate datetime NULL ,
	CustomerPhone varchar (15) NULL ,
	fkColorID int NOT NULL ,
	GarageOrderNumber int NOT NULL ,
	ResponseQueue varchar (255) NULL ,
	CONSTRAINT aaaaatblOrder_PK PRIMARY KEY  NONCLUSTERED 
	(
		OrderID
	),
	CONSTRAINT FK_tblOrder_tblCar FOREIGN KEY 
	(
		fkCarID
	) REFERENCES dbo.tblCar (
		CarID
	),
	CONSTRAINT FK_tblOrder_tblColor FOREIGN KEY 
	(
		fkColorID
	) REFERENCES dbo.tblColor (
		ColorID
	)
)
GO

 CREATE  INDEX GaragePostCode ON dbo.tblOrder(GarageTown)
GO

 CREATE  INDEX GaragePostCode1 ON dbo.tblOrder(CustomerName)
GO

 CREATE  INDEX OrderID ON dbo.tblOrder(OrderID)
GO

GRANT  SELECT ,  INSERT ,  UPDATE  ON tblOrder  TO public
GO


sp_addmessage 50001, 10, 'Not enough in stock'
GO

/****** Object:  Stored Procedure dbo.usp_StockDecrement    Script Date: 3/26/98 3:18:36 PM ******/
CREATE PROCEDURE usp_StockDecrement
			@CarID			int,
			@ColorID		int
AS
	DECLARE	@NumberInStock	integer

	SELECT	@NumberInStock = InStock
	FROM	tblCarColor
	WHERE	fkCarID = @CarID
	AND	fkColorID = @ColorID

	-- check there are enough in stock
	IF @NumberInStock < 1
	BEGIN
		-- not in stock therefore raise error
		RAISERROR (50001, 16, -1, @CarID)
		RETURN 50001
	END
	ELSE
	BEGIN
		-- in stock so decrement stock count
		UPDATE	tblCarColor
		SET	InStock = InStock - 1
		WHERE	fkCarID = @CarID
		AND	fkColorID = @ColorID
	END

	RETURN @NumberInStock - 1
GO

GRANT  EXECUTE  ON dbo.usp_StockDecrement  TO public
GO

/****** Object:  Stored Procedure dbo.usp_StockDecrementQ    Script Date: 3/26/98 3:28:46 PM ******/
CREATE PROCEDURE usp_StockDecrementQ
			@CarID			int,
			@ColorID		int
AS
	DECLARE	@NumberInStock	integer

	SELECT	@NumberInStock = InStock
	FROM	tblCarColor
	WHERE	fkCarID = @CarID
	AND	fkColorID = @ColorID

	-- check there are enough in stock
	IF @NumberInStock < 1
	BEGIN
		-- not in stock therefore add to on order count
		UPDATE	tblCarColor
		SET	OnOrder = OnOrder + 1
		WHERE	fkCarID = @CarID
		AND	fkColorID = @ColorID
	END
	ELSE
	BEGIN
		-- in stock so decrement stock count
		UPDATE	tblCarColor
		SET	InStock = InStock - 1
		WHERE	fkCarID = @CarID
		AND	fkColorID = @ColorID
	END

	RETURN @NumberInStock - 1
GO

GRANT  EXECUTE  ON dbo.usp_StockDecrementQ  TO public
GO



/****** Object:  Stored Procedure dbo.usp_OrderInsert    Script Date: 3/26/98 3:18:35 PM ******/
CREATE PROCEDURE usp_OrderInsert
					@GarageName 		varchar(50),
					@GarageAddress		varchar(50),
					@GarageTown			varchar(20),
					@GarageState		varchar(2),
					@GarageZipCode		varchar(15),
					@GarageOrderNumber	int,
					@SalesPerson		varchar(20),
					@CustomerName		varchar(20),
					@CustomerAddress	varchar(50),
					@CustomerTown		varchar(20),
					@CustomerState		varchar(2),
					@CustomerZipCode	varchar(15),
					@CustomerPhone		varchar(15),
					@CarID				int,
					@ColorID			int,
					@OrderNumber		varchar(10)	OUTPUT,
					@DeliveryDate		datetime	OUTPUT
AS

/*
// But :	Insrer un enregistrement dans la table des commandes 
// Remarques :	Cette procdure sera appele  partir d'un composant MTS, 
//		      donc on n'a pas besoin d'y grer les transactions.
//
// Historique des modifications 
// Date		Auteur		Description
// 07 Fv 1998	David Sussman	Premire version
// 
*/
BEGIN
	SET NOCOUNT OFF

	DECLARE	@InStock	integer
	DECLARE @Today		datetime

	SELECT @Today = GETDATE()

	-- on ajoute les donns de la commande 
	INSERT INTO tblOrder (GarageName, GarageAddress, GarageTown, GarageState, GarageZipCode,
		GarageOrderNumber, SalesPerson,
		CustomerName, CustomerAddress, CustomerTown, CustomerState, CustomerZipCode, CustomerPhone,
		fkCarID, DateOrdered, fkColorID)
	VALUES	(@GarageName, @GarageAddress, @GarageTown, @GarageState, @GarageZipCode,
		@GarageOrderNumber, @SalesPerson,
		@CustomerName, @CustomerAddress, @CustomerTown, @CustomerState, @CustomerZipCode, @CustomerPhone,
		@CarID, @Today, @ColorID)

	-- on dcrmente le stock
	EXEC @InStock = usp_StockDecrement @CarID, @ColorID

	-- Numro de commande et date de livraison sont des paramtres de sortie 
	-- REMARQUE : ici DeliveryDate est calcul de faon systmatique en
      --            ajoutant 14 jours  partir de la date o la commande  t passe.
	SELECT @OrderNumber = SUBSTRING (@GarageName, 1, 5) + CONVERT(varchar(5), @@IDENTITY)
	SELECT @DeliveryDate = DATEADD(day, 14, @Today)

	SET NOCOUNT ON

	RETURN	@InStock
END
GO

GRANT  EXECUTE  ON dbo.usp_OrderInsert  TO public
GO

/****** Object:  Stored Procedure dbo.usp_OrderInsertQ    Script Date: 3/26/98 3:18:35 PM ******/
CREATE PROCEDURE usp_OrderInsertQ
			@GarageName 		varchar(50),
			@GarageAddress		varchar(50),
			@GarageTown		varchar(20),
			@GarageState		varchar(2),
			@GarageZipCode		varchar(15),
			@GarageOrderNumber	int,
			@SalesPerson		varchar(20),
			@CustomerName		varchar(20),
			@CustomerAddress	varchar(50),
			@CustomerTown		varchar(20),
			@CustomerState		varchar(2),
			@CustomerZipCode	varchar(15),
			@CustomerPhone		varchar(15),
			@CarID			int,
			@ColorID		int,
			@ResponseQueue		varchar(255),
			@OrderNumber		varchar(10)	OUTPUT,
			@DeliveryDate		datetime	OUTPUT,
			@OrderID		int		OUTPUT
AS

/*
// But :	Insrer un enregistrement dans la table des commandes 
// Remarques :	On appelle cette procdure  partir d'un composant MTS, 
//			donc pas besoin de grer les transactions 
//
// Historique des modifications 
// Date		Auteur		Description
// 07 Feb 1998	David Sussman	premire version
// 
*/
BEGIN
	SET NOCOUNT OFF

	DECLARE	@InStock	integer
	DECLARE @Today		datetime

	SELECT @Today = GETDATE()

	-- ajout de la commande dans la table 
	INSERT INTO tblOrder (GarageName, GarageAddress, GarageTown, GarageState, GarageZipCode,
		GarageOrderNumber, SalesPerson,
		CustomerName, CustomerAddress, CustomerTown, CustomerState, CustomerZipCode, CustomerPhone,
		fkCarID, DateOrdered, fkColorID)
	VALUES	(@GarageName, @GarageAddress, @GarageTown, @GarageState, @GarageZipCode,
		@GarageOrderNumber, @SalesPerson,
		@CustomerName, @CustomerAddress, @CustomerTown, @CustomerState, @CustomerZipCode, @CustomerPhone,
		@CarID, @Today, @ColorID)

	-- dfinition de l'id de commande (paramtre de sortie)
	SELECT @OrderID = @@IDENTITY

	-- on dcrmente le stock
	-- la procdure incremente les commandes en attentes si lestock est insuffisant 
	EXEC @InStock = usp_StockDecrementQ @CarID, @ColorID

	-- Numro de commande et date de livraison sont des paramtres de sortie 
	-- REMARQUE : on calcule toujours DeliveryDate en ajoutant 14 jours,
	--		  sauf en cas de rupture de stock.
	SELECT @OrderNumber = SUBSTRING (@GarageName, 1, 5) + CONVERT(varchar(5), @OrderID)

	IF @InStock > 0
	BEGIN
		-- Mise  jour de la date de livraison (seulement si le modle est en stock)
		SELECT	@DeliveryDate = DATEADD(day, 14, @Today)
		UPDATE	tblOrder
		SET		DeliveryDate = @DeliveryDate
		WHERE	OrderID = @OrderID
	END
	ELSE
	BEGIN
		-- Mise  jour de la file de rponse pour pouvoir satisfaire 
		-- la commande plus tard. 
		UPDATE	tblOrder
		SET		ResponseQueue = @ResponseQueue
		WHERE	OrderID = @OrderID
	END

	SET NOCOUNT ON

	RETURN	@InStock
END
GO

GRANT  EXECUTE  ON dbo.usp_OrderInsertQ  TO public
GO

/****** Object:  Stored Procedure dbo.usp_OrderUpdateDeliveryDate    Script Date: 3/26/98 3:18:35 PM ******/
CREATE PROCEDURE usp_OrderUpdateDeliveryDate
		@OrderID		int,
		@DeliveryDate		datetime	OUTPUT
AS
/*
// But :	Mise  jour de la date de livraison pour une commande donne,
//		et suppression du message dans la fil de rponse. 
// Remarques :	Om appelle cette procdure  partir d'un composant MTS, 
//			donc pas besoin de grer les transactions.
//
// Historique des modifications 
// Date		Author		Description
// 07 Fv 1998	David Sussman	premire version
// 
*/
	UPDATE	tblOrder
	SET		DeliveryDate = @DeliveryDate,
			ResponseQueue = ''
	WHERE	OrderID = @OrderID
GO

GRANT  EXECUTE  ON dbo.usp_OrderUpdateDeliveryDate  TO public
GO

/****** Object:  Stored Procedure dbo.usp_OrdersNotConfirmed    Script Date: 3/26/98 3:18:36 PM ******/
CREATE PROCEDURE usp_OrdersNotConfirmed
AS
/*
// But :	Afficher les commandes en attente de confirmation. 
//
// Historique des modifications 
// Date		Auteur		Description
// 07 Feb 1998	David Sussman	Premire version
// 
*/
	SELECT	*, HOOrderNumber = SUBSTRING (GarageName, 1, 5) + CONVERT(varchar(5), OrderID)
	FROM	tblOrder
	WHERE	DeliveryDate IS NULL
	OR	DeliveryDate = 'Jan 1 1900 12:00AM'
GO

GRANT  EXECUTE  ON dbo.usp_OrdersNotConfirmed  TO public
GO
