// Search return with specified results

import java.util.Hashtable;
import java.util.Enumeration;

import javax.naming.*;
import javax.naming.directory.*;

public class JNDISearch {
   // initial context implementation 
   public static String INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";

   public static String MY_HOST = "ldap://localhost:389";
   public static String MY_SEARCHBASE = "o=fedup.com";

   public static String MY_FILTER = "(sn=Carter)";

   //specify which attributes we are looking for
   public static String MY_ATTRS[] = {"cn","mail"};

   public static void main(String args[]) {
      try {
         //Hashtable for environmental information
         Hashtable env = new Hashtable(); 

         //Specify which class to use for our JNDI provider
         env.put(Context.INITIAL_CONTEXT_FACTORY, INITCTX);

         // Specify host and port to use for directory service 
         env.put(Context.PROVIDER_URL, MY_HOST);

         //Get a reference to a directory context
         DirContext ctx = new InitialDirContext(env);

         //specify the scope of the search
         SearchControls constraints = new SearchControls();
         constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);

         //peform the actual search
         //we give it a searchbase, a filter and a the constraints
         //containing the scope of the search
         NamingEnumeration results = 
                              ctx.search(MY_SEARCHBASE,MY_FILTER,constraints);

         //now step through the search results
         while (results != null && results.hasMore()) {
            SearchResult sr = (SearchResult) results.next();

            String dn = sr.getName() + "," + MY_SEARCHBASE;
            System.out.println("Distinguished Name is "+dn);

            Attributes ar = ctx.getAttributes(dn, MY_ATTRS);

            if (ar == null) {
               System.out.println("Entry "+dn+" has none of the specified attributes\n");
            } else {
               for (int i =0;i<MY_ATTRS.length;i++) { 
                  Attribute attr = ar.get(MY_ATTRS[i]);
                  if (attr != null) {
                     System.out.println(MY_ATTRS[i]+":");
                     for (Enumeration vals =
                                  attr.getAll();vals.hasMoreElements();)
                     {
                        System.out.println("\t"+vals.nextElement());
                     }
                  }
                  System.out.println("\n");
               }
            } 
         }
      } catch(Exception e) {
         e.printStackTrace();
         System.exit(1);
      }
   }
}
