package com.wrox.WroxJiniClients;

import net.jini.core.entry.*;
import net.jini.lookup.entry.*;
import net.jini.entry.*;
import net.jini.discovery.*;
import net.jini.core.lookup.*;
import java.rmi.*;
import com.wrox.WroxJiniServices.*;

public class JiniUser implements DiscoveryListener {

    static JiniUser aClient;

    public static void main(String args[]) throws Exception {
        aClient = new JiniUser();
        System.out.println("A Simple Jini Client");
        System.out.println("Getting security manager");
        System.setSecurityManager(new RMISecurityManager());

        System.out.println("Starting Lookup Discovery ...");
        LookupDiscovery ld = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
        System.out.println("... and join");
        ld.addDiscoveryListener(aClient);

        System.out.println("Waiting to hear from REGGIE");
        synchronized(aClient) {
            aClient.wait();
        }
    }


    public void discovered(DiscoveryEvent e) {

        System.out.println("FOUND THE LOOKUP SERVICE!");

        try {
            ServiceRegistrar regs[] = e.getRegistrars();
            for (int i = 0; i < regs.length; i++) {
                System.out.println("Registrar " + regs[i].getLocator().toString()  );
                System.out.println(                                                );
                System.out.println("Searching for Entries I can call: "            );
                Entry entries[] = new Entry[] {new Name("wroxCallable")};
                ServiceMatches sm = regs[i].lookup(
                        new ServiceTemplate(null, null, entries),
                        10
                        );
                if (sm.totalMatches > 0) {
                    for (int j=0; j<sm.totalMatches; j++) {
                        IWroxJiniService myServ = (IWroxJiniService) sm.items[j].service;
                        System.out.println("Service Number: " + j + " found!");
                        System.out.println("Grabbed Data: " + myServ.grabData());
                    }
                }
            }
        } catch (Exception err) {
            System.out.println("Exception: " + err.getMessage());
            err.printStackTrace();
        }
    }

    public void discarded(DiscoveryEvent e) {

    }
}