package com.wrox.javaSpaces;

import com.sun.jini.mahout.binder.RefHolder;
import net.jini.core.lease.*;
import net.jini.space.JavaSpace;
import net.jini.core.transaction.*;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import net.jini.core.transaction.server.*;
import java.util.*;
import net.jini.core.entry.*;

public class HumanVerificationNode extends ServerNode
{

   static final String IN_SPACE = "ConfirmedSpace";
   static final String OUT_GOODSPACE = "SuccessSpace";
   static final String OUT_BADSPACE = "FailureSpace";
   static final double CHANCE_OF_HUMAN_APPROVAL = 0.8;
   static final int MAX_PROCESS_TIME = 10000;
   private JavaSpace inSpace;
   private JavaSpace successSpace;
   private JavaSpace failSpace;
   private Random myRand = new Random();

   public HumanVerificationNode()
   {
      super();
   }

   public void Initialize()
   {
      if (System.getSecurityManager() == null)
      {  System.setSecurityManager(new RMISecurityManager()); }

      System.out.println("Human Verification server running...");
      inSpace = locateSpace(IN_SPACE);
      successSpace = locateSpace(OUT_GOODSPACE);
      failSpace = locateSpace(OUT_BADSPACE);
   }

   public void doWork()
   {

      TransactionManager txMgr = findTxManager();
      UserEntry workEntry, secondEntry;
      Transaction.Created mycr;
      Transaction mytx;

      if (txMgr != null)
      {
         while (true)
         {
            try
            {
               while (true)
               {
                  mycr = TransactionFactory.create(txMgr, 6 * MAX_PROCESS_TIME);
                  mytx = mycr.transaction;
                  workEntry = null;
                  secondEntry = null;
                  try
                  {
                     workEntry = (UserEntry) inSpace.take(
                          new UserEntry(null, null, null, null,
                                             null, new Boolean(true)),
                          mytx,
                          Lease.FOREVER
                          );
                     System.out.println(
                                "Took an entry for Name: " + workEntry.userName +
                                        "... Waiting for second.");
                     secondEntry = (UserEntry) inSpace.take(
                          new UserEntry(workEntry.userName, workEntry.memberID,
                                             null, null,null, null),
                          mytx,
                          MAX_PROCESS_TIME
                          );
                  }
                  catch (TransactionException err)
                  {
                     System.out.println("Timeout waiting for item... Resetting.");
                     continue;
                  }

                  if (secondEntry == null)
                  {
                     System.out.println("Waited too long. Aborting...");
                     mytx.abort();
                     continue;
                  }
                  else
                  {
                     System.out.println("Got the other one!");
                     mytx.commit();
                     break;
                  }
               }

               workEntry.creditLimit = secondEntry.creditLimit;

               if (!(workEntry.verified.booleanValue())
                     || (workEntry.creditLimit.doubleValue()
                               == 0.0))
               {
                  System.out.println("Rejected without need for human approval...");
                  failSpace.write(workEntry, null, Lease.FOREVER);
               }
               else
               {
                  System.out.println("Performing human check...");
                  if (performHumanCheck(workEntry))
                  {
                     System.out.println("Approved!");
                     successSpace.write(workEntry, null, Lease.FOREVER);
                  }
                  else
                  {
                     System.out.println("Rejected.");
                     workEntry.verifyFlag = new Boolean(false);
                     failSpace.write(workEntry, null, Lease.FOREVER);
                  }
               }
            }
            catch (Exception err)
            {
               System.out.println(err.getMessage());
               err.printStackTrace();
               System.exit(1);
            }
         }
      }
      else
      {  System.out.println("Transaction manager not available!"); }
   }

   boolean performHumanCheck(UserEntry myEntry)
   {
      return (myRand.nextDouble() < CHANCE_OF_HUMAN_APPROVAL);
   }

   public static void main(String[] args)
   {
      HumanVerificationNode myNode = new HumanVerificationNode();
      myNode.Initialize();
      myNode.doWork(); // forever
      System.exit(0);
   }
}