package com.wrox.javaSpaces;

import com.sun.jini.mahout.binder.RefHolder;
import net.jini.core.lease.*;
import net.jini.space.JavaSpace;
import net.jini.core.transaction.Transaction;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.util.*;
import net.jini.core.entry.*;

public class NameVerifierNode extends ServerNode
{

   static final String IN_SPACE = "VerifySpace";
   static final String OUT_SPACE = "ConfirmedSpace";
   static final double CHANCE_OF_VERIFICATION = 0.8;
   private JavaSpace inSpace;
   private JavaSpace outSpace;
   private Random myRand = new Random();

   public NameVerifierNode()
   {
      super();
   }

   public void Initialize()
   {
      if (System.getSecurityManager() == null)
      {  System.setSecurityManager(new RMISecurityManager()); }

      System.out.println("Name verifier server running...");
      inSpace = locateSpace(IN_SPACE);
      outSpace = locateSpace(OUT_SPACE);
   }

   public void doWork()
   {
      while (true)
      {
         try
         {
            UserEntry workEntry = (UserEntry) inSpace.take(
                          new UserEntry(null,null,null,null,null,null), // Template
                          null,                                         // Transaction
                          Lease.FOREVER                                 // Time to wait
                          );
            System.out.println("Took an entry for Name: " + workEntry.userName + "...");
            workEntry.verified = verifyName(workEntry.userName, workEntry.memberID);
            System.out.println("Checked for authenticity... result is " +
                      (workEntry.verified.booleanValue()
                              ? "positive"
                              : "negative"
                      ));
            workEntry.verifyFlag = new Boolean(true);   // to show entry is from NameVerifier
            outSpace.write(workEntry, null, Lease.FOREVER);
         }
         catch (Exception err)
         {
            System.out.println(err.getMessage());
            err.printStackTrace();
         }
      }
   }

   Boolean verifyName(String userName, String memberID)
   {
      boolean tpBool = (myRand.nextDouble() < CHANCE_OF_VERIFICATION);
      return new Boolean(tpBool);
   }

   public static void main(String[] args)
   {
      NameVerifierNode myNode = new NameVerifierNode();
      myNode.Initialize();
      myNode.doWork(); // forever
      System.exit(0);
   }
}