//Source file: C:/work/Wrox/case_study/code/BugTrackerApp/businesslogic/MailMessage.java

package businesslogic;

import apputil.*;

import java.net.*;
import java.io.*;
import java.util.*;

/**
MailMessage provides an encapsulated means of constructing and sending
an internet mail message without having to understand SMTP.
*/
public class MailMessage implements Testable
{
	String m_Body;
	String[] m_Recipient;
	String m_BugTrackerAgentEmail;
	String m_Host;
	int m_RecipientCount;
	Socket m_SMTPSocket;
	DataOutputStream m_OutputToServer;
	BufferedReader m_InputFromServer;
	 
	final static int HOSTPORT=25;
	
	/**
	Default constructor; initializes message information and retrieves
	mail host information from application configuration properties.
	*/
	public MailMessage() 
	{
		AppConfig config = new AppConfig();
		m_Host = config.getSMTPHost();
		m_BugTrackerAgentEmail = config.getBugTrackerAgentEmail();
		m_SMTPSocket = null;
		m_RecipientCount = 0;
	
		}
	
	/**
	   accessor method
   */
	public void setMessage(String text) 
	{
		m_Body = text;
		}
	
	/**
	  accessor method
	  @param rcpt a single or delimited list of mail recipients. mail addresses can be delimited with spaces semicolons or commas
	   */
	public void setRecipient(String rcpt) 
	{
		Vector vRcpt = new Vector();
		
		// unfortunately, the StreamTokenizer class is too brain-dead
		// to perform the basics that we need here, so we'll parse this
		// ourselves.
		
		StringBuffer sb = new StringBuffer(rcpt);
		int nLen = sb.length();
		
		// convert commas and semicolons into spaces
		for (int n=0; n < nLen; n++)
		{
			if ((sb.charAt(n) == ',') ||
				(sb.charAt(n) == ';'))
					sb.setCharAt(n, ' ');
		}
		
		String maillist = sb.toString().trim();
		int nPos = 0;
		while (nPos < maillist.length())
		{
			String addressToAdd;
			
			int endPos = maillist.indexOf(' ', nPos);
			if (endPos != -1) // found a space
			{
				addressToAdd = maillist.substring(nPos, endPos).trim();
				nPos = endPos;
				nPos++; //advance char pos by one char
			}
			else //no spaces
			{
				addressToAdd = maillist.substring(nPos, maillist.length()).trim();
				nPos = maillist.length(); // get to end of string
			}
			
			if (addressToAdd.trim().length() > 0)
			{
				vRcpt.addElement(addressToAdd);
				m_RecipientCount++;
			}
			
		}
				
		m_Recipient = new String[vRcpt.size()];
		m_Recipient = (String[])vRcpt.toArray(m_Recipient);
	}
	
	/**
	  Mails the message to the recipient(s) by way of the 
	  SMTP host specified by the smtphost value in the 
	  application properties
	  @exception IOException thrown if there are transmission errors
	  @exception UnknownHostException thrown if the host cannot be found
	  */
	public void send() throws IOException , UnknownHostException
	{
		String inbuffer;
		
		if (m_RecipientCount > 0)
		{
		
				getConnection();
				
				inbuffer = m_InputFromServer.readLine();
				m_OutputToServer.writeBytes("HELO bugtracker\n");
				inbuffer = m_InputFromServer.readLine();
				m_OutputToServer.writeBytes("RSET\n");
				inbuffer = m_InputFromServer.readLine();
				m_OutputToServer.writeBytes("MAIL FROM:<" + 	m_BugTrackerAgentEmail + ">\n");
				inbuffer = m_InputFromServer.readLine();
				
				for (int n = 0 ; n < m_RecipientCount; n++)
				{
					m_OutputToServer.writeBytes("RCPT TO:<" + m_Recipient[n] + ">\n");
					inbuffer = m_InputFromServer.readLine();
				}
				
				m_OutputToServer.writeBytes("DATA\n");
				inbuffer = m_InputFromServer.readLine();
				m_OutputToServer.writeBytes(m_Body + "\n");
				m_OutputToServer.writeBytes(".\n");
				inbuffer = m_InputFromServer.readLine();
				m_OutputToServer.writeBytes("QUIT\n");
				
				m_SMTPSocket.close();
					
		}
	}


	/**
	connects to the SMTP host. 
	@exception IOException thrown if there are transmission errors
	@exception UnknownHostException thrown if the host identified in the application properties cannot be located
	*/	
	void getConnection() throws IOException, UnknownHostException
	{
		m_SMTPSocket = new Socket(m_Host, HOSTPORT);
		OutputStream os = m_SMTPSocket.getOutputStream();
		m_OutputToServer = new DataOutputStream(os);
		InputStream is = m_SMTPSocket.getInputStream();
		m_InputFromServer = new BufferedReader(new InputStreamReader(is));
	}
	
	/**
	Support method for Testable interface. Allows unit to be exercised under the
	apputil.TestHarness class
	*/
	public boolean TestUnit()
	{
		boolean retval;
		retval = false;
		
		this.setRecipient("rkp root");
		this.setMessage("Subject: unit test of MailMessage.java\nThis is a test");
		try
		{
			this.send();
			retval = true;
		}
		catch (UnknownHostException uhe)
		{
			System.out.println("Unit test of MailMessage failed : " + uhe.toString());
		}
		catch (IOException ioe)
		{
			System.out.println("Unit test of MailMessage failed : " + ioe.toString());
		}
	
		return retval;
		
	};
}