package businesslogic;

//import application packages
import businessmodel.*;
import dataabstraction.PersistentUser;

//import system packages
import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;
import org.omg.CORBA.*; 
import java.sql.SQLException;

/**
This class provides an implementation of the _UserFactoryIntfOperations, used by the
tie class generated by idltojava. This class provides a factory for creating and
accessing User objects maintained by the application.
*/
public class UserFactory implements _UserFactoryIntfOperations 
{
	public DefectPolicy m_DefectPolicy;
	
	/**
	Constructor
	@param thePolicy DefectPolicy object, used to enforce application policies
	*/
	public UserFactory(DefectPolicy thePolicy) 
	{
		m_DefectPolicy = thePolicy;

		}
	
	/**
	accessor method
	 */
	public businesslogic.DefectPolicy getPolicyObject() 
	{
		return m_DefectPolicy;
		
	}
	
	/**
	creates user object
	@param requestor id of requestor
	@param userid id of user to create
	@exception AlreadyExistsException thrown if userid already exists
	@exception AppSecurityException thrown if requestor doesn't have adequete privileges
	*/
	public UserIntf NewUser(String requestor, String userid) throws AlreadyExistsException, AppSecurityException
	{
		return m_DefectPolicy.createNewUser(requestor, userid);	
	}
	
	/**
	retrieves user object
	@param requestor id of requestor
	@param userid id of user requested
	@exception NotFoundException thrown if requested user doesn't exist
	@exception AppSecurityException thrown if requestor doesn't have adequete privileges
	*/
	public UserIntf getUser(String requestor, String userid) throws NotFoundException, AppSecurityException
	{
		
		/*
		If the requestor doesn't have admin privileges, throw AppSecurityException
		*/
		if (!m_DefectPolicy.canAdminister(requestor))
			throw new AppSecurityException();
			
		try
		{
			businessmodel._UserIntfTie base;
			
			// need to get assign a new uid to the defect
			PersistentUser theUser = 	new PersistentUser();
			theUser.setUserID(userid);
			theUser.fetch();
			
			/* create the tie object, bind it to the user,
				 and let the policy object bind it to the orb */	
			
			base = new businessmodel._UserIntfTie(theUser);
			m_DefectPolicy.implConnect(base);
	
			return base;
		
		}		
		catch(SQLException sqle)
		{
			throw new NotFoundException();
		}
		
	}
	
	/**
	Retrieves an array of the user ids for all users in the system
	@return returns an array of Strings containing the user ids
	*/
	public String[] getUserList()
	{
		PersistentUser pUser = new PersistentUser();
		return pUser.getUserIDList();
	}
		
	

}	