// Source file: c:/work/wrox/casest~1/code/BugTrackerApp/ui/DefectForm.java

package ui;

import businessmodel.*;
import businesslogic.*;

import javax.swing.*;
import javax.swing.filechooser.*;

import javax.swing.border.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import org.omg.CORBA.*;
import org.omg.CosNaming.*;

/**
This class is the primary user interface for the BugTracker client. This
provides a Swing-based, multi-tabbed interface for creating, modifying and
querying defect information.
*/
public class DefectForm extends JFrame 
{
    
    SummaryForm m_SummaryForm;
    DetailForm m_DetailForm;
    NotificationForm m_NotificationForm;
    ResolutionForm m_ResolutionForm;
    
    UIDefectModel m_Model;
    DefectServerIntf m_DefectServer;
    DefectFactoryIntf m_DefectFactory;
    DefectPolicyIntf m_DefectPolicy;
    ORB m_Orb;
    
    String m_activeUser;
    JTabbedPane m_Pane;
    
  	public void setUserID(String uid)
		{
				m_activeUser = uid;
		
			}

		/**
		Constructor. initializes the user interface and internal members.
		@param orb reference to an ORB created by the calling method
		@param bugserver reference to remote DefectServerIntf object
		*/
		public DefectForm(ORB orb, DefectServerIntf bugserver)
		{
			super("BugTracker/J");
			m_DefectServer = bugserver;
			m_Orb = orb;
			
			// get the user id from the system properties
			String uid = System.getProperties().getProperty("user.name");
			setUserID(uid);
			
			m_DefectFactory = m_DefectServer.getDefectFactory();
			m_DefectPolicy = m_DefectServer.getPolicyObject();	
			m_Model = new UIDefectModel();	
			
			createEmptyDefect();
			
			initialize();
			
			m_Model.UpdateListeners();
		}
		
		/**
		adds the defect summary tab to the window
		*/
		void addSummaryTab()
		{
			m_SummaryForm = new SummaryForm();
			m_Pane.addTab("Summary", null, m_SummaryForm, "Defect summary information");
			m_Model.addDefectModelListener(m_SummaryForm);
		
		 };
		 
		/**
		adds the defect detail tab to the window
		*/ 
		void addDetailTab()
		{
			m_DetailForm = new DetailForm();
			m_Pane.addTab("Detail", null, m_DetailForm, "Defect detail information");
			m_Model.addDefectModelListener(m_DetailForm);
		
		 };
		
		/**
		adds the defect resolution tab to the window
		*/
		void addResolutionTab()
		{
			m_ResolutionForm = new ResolutionForm();
			m_Pane.addTab("Resolution", null, m_ResolutionForm, "Defect resolution information");
			m_Model.addDefectModelListener(m_ResolutionForm);
		
			};
			
			
		/**
		adds the notification tab to the window
		*/	
		void addNotificationTab()
		{
			m_NotificationForm = new NotificationForm();
			m_Pane.addTab("Notification", null, m_NotificationForm, "Automated notification information");
			m_Model.addDefectModelListener(m_NotificationForm);
			
		};
		 
		/**
		Initializes the BugTracker client user interface components
		*/ 
		public void initialize()
	  {
	  	
	  	/* create the handler objects that will be used
	  	   by the menu and the toolbar buttons */
	  	   
	  	FileNewHandler NewHandler = new FileNewHandler(this);
	  	FileOpenHandler OpenHandler = new FileOpenHandler(this);
	  	FileSaveHandler SaveHandler = new FileSaveHandler(this);
	  	FileExitHandler ExitHandler = new FileExitHandler(this);
	  	FileExportToXMLHandler ExportHandler = new FileExportToXMLHandler(this); 
	  	
	  	/*	Feature Not Implemented
	  	ViewTaskListHandler TaskListHandler = new ViewTaskListHandler(this);
	  	*/
	  	
	  	// set the layout	  	
			this.getContentPane().setLayout(new BorderLayout());			
			
			// add a JTabbedPane to frame
			m_Pane = new JTabbedPane();
			getContentPane().add(m_Pane, BorderLayout.CENTER);
			
			// create the menubar, the menus and their respective items
			JMenuBar theMenuBar = new JMenuBar();
			
			
			// build the file menu
			JMenu FileMenu = new JMenu("File");

			JMenuItem FileNewDefect = new JMenuItem("New Defect");
			FileNewDefect.setMnemonic('N');
			FileNewDefect.addActionListener(NewHandler);
			
			JMenuItem FileOpenDefect = new JMenuItem("Open Defect");
			FileOpenDefect.setMnemonic('O');
			FileOpenDefect.addActionListener(OpenHandler);
			
			JMenuItem FileSaveDefect = new JMenuItem("Save Defect");
			FileSaveDefect.setMnemonic('S');
			FileSaveDefect.addActionListener(SaveHandler);
			
			JMenuItem FileExportXML = new JMenuItem("Export as XML...");
			FileExportXML.setMnemonic('X');
			FileExportXML.addActionListener(ExportHandler);
			
			JMenuItem FileExit = new JMenuItem("Exit");
			FileExit.setMnemonic('X');
			FileExit.addActionListener(ExitHandler);
			
			FileMenu.add(FileNewDefect);
			FileMenu.add(FileOpenDefect);
			FileMenu.add(FileSaveDefect);
			FileMenu.add(FileExportXML);
			FileMenu.addSeparator();
			FileMenu.add(FileExit);
			theMenuBar.add(FileMenu);
			
			// build the view menu
			/* Feature Not Implemented 
			JMenu ViewMenu = new JMenu("View");
			
			JMenuItem ViewTaskList = new JMenuItem("View assigned defects");
			ViewTaskList.setMnemonic('V');
			ViewTaskList.addActionListener(TaskListHandler);
			
			ViewMenu.add(ViewTaskList);
			theMenuBar.add(ViewMenu);
			*/
			
			// add the menubar to the frame
			this.setJMenuBar(theMenuBar);
			
			// build the toolbar
			JToolBar theToolbar = new JToolBar();
			theToolbar.setFloatable(true);
			ImageIcon NewImage = new ImageIcon("newbug.gif");
			JButton NewButton = new JButton(NewImage);
			NewButton.setToolTipText("Create a new defect report");
			NewButton.addActionListener(NewHandler);
			theToolbar.add(NewButton);
			
			ImageIcon OpenImage = new ImageIcon("findbug.gif");
			JButton OpenButton = new JButton(OpenImage);
			OpenButton.setToolTipText("Open an exising defect");
			OpenButton.addActionListener(OpenHandler);
			theToolbar.add(OpenButton);
			
			ImageIcon SaveImage = new ImageIcon("savebug.gif");
			JButton SaveButton = new JButton(SaveImage);
			SaveButton.setToolTipText("Save the current defect");
			SaveButton.addActionListener(SaveHandler);
			theToolbar.add(SaveButton);
			
			/* Feature Not Implemented
			ImageIcon TasklistImage = new ImageIcon("tasklist.gif");
			JButton TaskButton = new JButton(TasklistImage);
			TaskButton.setToolTipText("View open defects assigned to you");
			TaskButton.addActionListener(TaskListHandler);
			theToolbar.add(TaskButton);
			*/
			
			theToolbar.addSeparator();
			ImageIcon ExitAppImage = new ImageIcon("exitapp.gif");
			JButton ButtonExitApp = new JButton(ExitAppImage);
			ButtonExitApp.setToolTipText("Exit the BugTracker application");
			ButtonExitApp.addActionListener(ExitHandler);
			theToolbar.add(ButtonExitApp);
			
			theToolbar.setBorder(new EtchedBorder(EtchedBorder.LOWERED));
			
			this.getContentPane().add(theToolbar, BorderLayout.NORTH);
			
			setBounds(10, 10, 600, 500);
			
			addSummaryTab();
			addDetailTab();
			addNotificationTab();
			addResolutionTab();
			
			setVisible(true);
		
		  }

		/**
		Entry point for user interface of the defect tracking application
		*/    
		public static void main(String[] args)
		{
				apputil.AppConfig config;
				ui.DefectForm theForm;
			
		
				try
				{
					if (args.length == 0)
				  	config = new apputil.AppConfig("c:\\work\\wrox\\case_study\\code\\BugTrackerApp\\BUGTRACKER.PROPS");
					else
						config = new apputil.AppConfig(args[0]);	   					

			    // create and initialize the ORB
			    ORB orb = ORB.init(args, null);
		 
		      // get the root naming context
		      org.omg.CORBA.Object objRef = orb.resolve_initial_references("NameService");
		      NamingContext ncRef = NamingContextHelper.narrow(objRef);
		
		      // resolve the Object Reference in Naming
		      NameComponent nc = new NameComponent(config.getBugServerServiceName(), "");
		      NameComponent path[] = {nc};
		      
		      //Get a reference to the bug server
		      DefectServerIntf theBugServer;
		      theBugServer = DefectServerIntfHelper.narrow(ncRef.resolve(path));
		 
			    /* if we've been able to get a reference to the bug server,
			       go ahead and create the UI and pass the reference along
			       to the UI object */
			       
					theForm = new DefectForm(orb, theBugServer);	       
										
					
										
				} 
				catch (Exception e)
				{
			    System.out.println("ERROR : " + e) ;
			    e.printStackTrace(System.out);
					}
		}
		
		/**
		helper method - populates ui with a new defect
		*/
	
		void createEmptyDefect()
		{
				DefectIntf aDefect = m_DefectFactory.NewDefect(m_activeUser);
				m_Model.setActiveDefect(aDefect);
				
		}
		
		/**
		helper method - handles File/New action
		*/	
		void doFileNew()
		{
				createEmptyDefect();		
				// set the focus back to the summary pane
				m_Pane.setSelectedIndex(0);
			
		}
		
		
		/**
		helper method - handles File/Save action
		*/
		void doFileSave()
		{
				m_Model.UpdateModel();
				try
				{
					m_Model.getActiveDefect().commit(m_activeUser);
				}
				catch(businessmodel.UpdateException ue)
				{	
					JOptionPane.showMessageDialog(this, 
						"Unable to save defect!", 
						"Defect Update Error", 
						JOptionPane.ERROR_MESSAGE);
	
				}
				catch(businessmodel.AppSecurityException ase)
				{
						JOptionPane.showMessageDialog(this, 
						"SECURITY VIOLATION! Insufficient privileges for this operation", 
						"Insufficient Privileges", 
						JOptionPane.ERROR_MESSAGE);
				}
		}
		
		/**
		helper method - handles File/Save action
		*/
		
		void doFileOpen()		
		{
			String id;
			id = JOptionPane.showInputDialog(this,
						"Enter defect id", 
						"Open existing defect",
						JOptionPane.OK_CANCEL_OPTION);
						
			if (id != null)
			{
				try
				{
					int intid = Integer.parseInt(id);
					DefectIntf aDefect = m_DefectFactory.getDefect(intid);
					m_Model.setActiveDefect(aDefect);
					// set the focus back to the summary pane
					m_Pane.setSelectedIndex(0);
				}
				catch (NumberFormatException nfe)
				{
					JOptionPane.showMessageDialog(this,
						"Invalid defect number format",
						"Invalid defect id",
						JOptionPane.ERROR_MESSAGE);
				}
				catch (NotFoundException nfe)
				{
					JOptionPane.showMessageDialog(this,
							"No matching defect found",
							"Not found",
							JOptionPane.ERROR_MESSAGE);
				}
			}
		}

		/**
		helper method - handles File/Export to XML action
		*/
		
		void doExportToXML()
		{
			JFileChooser jchoose = new JFileChooser();
	
			int chooserval = jchoose.showSaveDialog(this);
			if (chooserval == JFileChooser.APPROVE_OPTION)
			{
				try
				{
					String xmlmodel = m_Model.getActiveDefect().exportToXML();
					FileWriter fw = new FileWriter(jchoose.getSelectedFile());
					fw.write(xmlmodel, 0, xmlmodel.length());
					fw.flush();
					fw.close();
				}
				catch(IOException ioe)
				{
					JOptionPane.showMessageDialog(this, ioe.toString(), "Error saving as XML",
						JOptionPane.WARNING_MESSAGE);
				}
			}
		
		}
	
	/* Feature Not Implemented
	void doViewTaskList()
	{
		
	}	
	*/
		
	/**
	check to see if current defect has been dirtied and needs to be saved. If the
	return value is false, the current defect will remain active.
	*/
	boolean handleDirtyDefect()
	{
		boolean retval = false;
		
		if (m_Model.isDirty())
		{
			int option;
			
			
			option = JOptionPane.showConfirmDialog(this, 
							"Save current defect first?", 
							"Save defect?", 
							JOptionPane.YES_NO_CANCEL_OPTION);
					
			if (option == JOptionPane.YES_OPTION)
			{
					m_Model.UpdateModel();
					try
					{
						m_Model.getActiveDefect().commit(m_activeUser);
						retval = true;
					}
					catch(businessmodel.UpdateException ue)
					{	
						option = JOptionPane.showConfirmDialog(this, 
							"Unable to save defect. Continue & discard changes?", 
							"Discard changes?", 
							JOptionPane.YES_NO_OPTION);
							
						if (option == JOptionPane.YES_OPTION)
								retval = true;
						else
								retval = false;
	
					}
					catch(businessmodel.AppSecurityException ase)
					{
							option = JOptionPane.showConfirmDialog(this, 
							"SECURITY VIOLATION! Continue & discard changes?", 
							"Discard changes?", 
							JOptionPane.YES_NO_OPTION);
							
						if (option == JOptionPane.YES_OPTION)
								retval = true;
						else
								retval = false;
					}
			}
			else
			{
				if (option == JOptionPane.NO_OPTION)
					retval = true;
				else
					retval = false;			
			}
		}
		else
			retval = true;
		
		return retval;
	}

	/**
	Nested class for handling action event
	*/
	class FileExitHandler implements ActionListener
	{
		
		DefectForm m_Form;
		
		public FileExitHandler(DefectForm form)
		{
			m_Form = form;
		}
	
		public void actionPerformed(ActionEvent e)
		{
			if (m_Form.handleDirtyDefect())
				System.exit(0);
		}
	 }
	 
	
	/**
	Nested class for handling action event
	*/
	
	class FileOpenHandler implements ActionListener
	{
		DefectForm m_Form;
		
		public FileOpenHandler(DefectForm form)
		{
			m_Form = form;	
		}	
		
	
		public void actionPerformed(ActionEvent e)
		{
			if (m_Form.handleDirtyDefect())
				m_Form.doFileOpen();
		}
			
	 }
	 
	
	/**
	Nested class for handling action event
	*/
	class FileNewHandler implements ActionListener
	{
		DefectForm m_Form;
		
		public FileNewHandler(DefectForm form)
		{
			m_Form = form;	
		}	
	
		public void actionPerformed(ActionEvent e)
		{
			if (m_Form.handleDirtyDefect())
				m_Form.doFileNew();
		}
	 }
 
	 
	
	/**
	Nested class for handling action event
	*/
	class FileSaveHandler implements ActionListener
	{
		
		DefectForm m_Form;
		
		FileSaveHandler(DefectForm form)
		{
			m_Form = form;	
		}	
	
		public void actionPerformed(ActionEvent e)
		{
			m_Form.doFileSave();
		}
	 }
	 
	
	/**
	Nested class for handling action event
	*/
	class FileExportToXMLHandler implements ActionListener
	{
		DefectForm m_Form;
		FileExportToXMLHandler(DefectForm form)
		{
			m_Form = form;	
		}
		public void actionPerformed(ActionEvent e)
		{
			if (m_Form.handleDirtyDefect())
				m_Form.doExportToXML();
		}
		
	} 

	/* Feature Not Implemented 
	class ViewTaskListHandler implements ActionListener
	{
		DefectForm m_Form;
		
		ViewTaskListHandler(DefectForm form)
		{
			m_Form = form;	
		}	
	
		public void actionPerformed(ActionEvent e)
		{
			m_Form.doViewTaskList();
		}
 }
 */

}