/*~

    file    :   build_tables.java
    revision history
    ---------------------------------------
    date        initials        description
    ---------------------------------------
    10.1.96     rkp

~*/

/**
 * routine to build example tables with established jdbc data source
 * Demonstrate basic JDBC program
 *      Load a driver
 *      Create a Connection
 *      read lines of SQL from definintion file
 *      execute each line

 *@author rkp
 *@version 1.0

        performs DDL as scripted in a text file.
        the input file is specified as the single command line argument.

        the input file must adhere to the following format:
        <driver class name>
        <data source url>
        <user name>
        <password>
        <sql statement>
        <sql statement>
        ...


        blank lines, after the password, will be ignored.
        lines beginning with '#' will be treated as comments



 *
 */

 // import the jdbc classes

 import java.sql.*;
 import java.io.*;

 public class build_tables
 {

    public static void main(String args[])
    {
        // Load the driver
        try
        {

            if (args.length < 1)
            {
                System.out.println("Use: build_tables tabldef.sql");
                System.exit(1);
            }

            // load the driver class
            FileReader fIn = new FileReader(args[0]);
            BufferedReader brIn = new BufferedReader(fIn);
            
            String driverClass = brIn.readLine().trim();
            String sourceURL = brIn.readLine().trim();
            Class.forName(driverClass);

            String userName = brIn.readLine().trim();
            String password = brIn.readLine().trim();

            // create connection through the DriverManager
            Connection databaseConnection =
                DriverManager.getConnection(sourceURL, userName, password);

            boolean done = false;
            while(!done)
            {
                String sqlString = null;
                try
                {
                    sqlString = brIn.readLine();
                    if (sqlString != null)
                    {
                        sqlString = sqlString.trim();

                        // ignore empty lines and lines starting with hashmark
                        if ((sqlString.length() > 0) && (sqlString.charAt(0) != '#'))
                        {
                            Statement stmt = databaseConnection.createStatement();
                            stmt.executeUpdate(sqlString);

                            //print dots to show progress
                            System.out.print(".");
                            //System.out.println("Executing: " + sqlString);
                        }
                    }
                    else
                        done = true;

                }


                catch(SQLException sqle)
                {
                    System.out.println("Error executing statement:" + sqlString);
                    System.out.println(sqle);
                }
                catch(IOException ioe)
                {
                    done = true;
                }



            }



        }

        catch(ClassNotFoundException cnfe)
        {
            System.out.println(cnfe);
        }
        catch(SQLException sqle)
        {
            System.out.println(sqle);
        }
        catch(FileNotFoundException fnfe)
        {
            System.out.println("Cannot open file " + args[0]);
        }
        catch(IOException ioexcept)
        {
            System.out.println(ioexcept);
        }

    }
 }
