//Import Servlet Libraries
import javax.servlet.*;
import javax.servlet.http.*;

//Import Java Libraries
import java.util.*;
import java.sql.*;
import java.io.*;

public class dbpool extends HttpServlet {

  int limit = 2;        //Set initial limit to 2
  int users = 0;        //Track user count with this variable

  Vector db_v;          //Vector to manage connections
  Vector db_status;     //Vector to keep track of open connections

  public void init() throws ServletException {

    /* Create initial pool of database connections */
    try {
      db_v = new Vector();
      db_status = new Vector();
      Class.forName(getInitParameter("JdbcDriver"));
      String dbURL = getInitParameter("dbURL");
      for (int i=0; i<limit; i++) {
        db_v.addElement(DriverManager.getConnection(dbURL));
        db_status.addElement("0"); // "0" - Available Connection
      }
    }
    catch (Exception e) {
      System.out.println("Ex33:Database connect failed (init)");
      System.out.println(e.toString());
      return;
    }

  }

  public void doGet(HttpServletRequest _req, HttpServletResponse _res)
    throws ServletException, IOException {

    _res.setContentType("text/html");
    PrintWriter out = _res.getWriter();

    /* If necessary, add a new connection */
    users++;
    if (users > limit) {
      if(!addConnection()) {
        _res.sendError(_res.SC_ACCEPTED, "The request has been accepted, but it failed to complete due to an error connecting to the database.");
        return;
      }
    }

    /* Assign to an open database connection object */
    boolean found = false;
    int i = 0;
    String val = "";
    while (!found) {
      val = (String)db_status.elementAt(i);
      if (val.equals("0")) {
        found = true;
      }
      else {
        i++;
      }
    }
    Connection dbCon = (Connection)db_v.elementAt(i);
    db_status.setElementAt("1", i);

    /* Do some database stuff..... */
    String count = "";
    try {
      Statement s = dbCon.createStatement();
      ResultSet rs = s.executeQuery("select count(*) from dailySales");
      if (rs.next()) {
        count = rs.getString(1);
        Thread.sleep(500);  // Simulate a pause for testing purposes
      }
    }
    catch (SQLException e) {
      _res.sendError(_res.SC_ACCEPTED, "The request has been accepted, but it failed to complete due to an error updating the database.");
      System.out.println(e.toString());
      return;
    }
    catch (InterruptedException e) {
      // Necessary for testing purposes (Thread.sleep() method)
    }

    //Return some results.....

    out.println("<HTML>");
    out.println("<HEAD>");
    out.println("<TITLE>Database Pooling Test Results</TITLE>");
    out.println("<BODY>");
    out.println("Database Operation: Table Count - " + count + " records");
    out.println("<br>User Count: " + String.valueOf(users));
    out.println("<br>Threshhold: " + String.valueOf(limit));
    out.println("</BODY>");
    out.println("</HTML>");

    out.close();

    /* Reset user count to free up connection object */
    users--;
    db_status.setElementAt("0", i);

  }

  public boolean addConnection() {

    /* Create another database connection */
    try {
      String dbURL = getInitParameter("dbURL");
      db_v.addElement(DriverManager.getConnection(dbURL));
      db_status.addElement("0"); // "0" - Available Connection
      limit++;
    }
    catch (Exception e) {
      System.out.println("Ex33: Database connect failed (addConnection)");
      System.out.println(e.toString());
      return false;
    }

    return true;

  }

  public void destroy() {

    /* Close database connections */
    try {
      Enumeration enum = db_v.elements();
      while (enum.hasMoreElements()) {
        Connection dbCon = (Connection)enum.nextElement();
        dbCon.close();
      }
    }
    catch (Exception e) {
      System.out.println("Ex33:Error closing database (destroy)");
      System.out.println(e.toString());
    }

  }

}
