import java.util.*;


public class AcceptList
{
  private String[] names;
  private double[] qualities;


  public AcceptList(String s)
  {
    if(s == null)
    {
      names = new String[0];
      qualities = new double[0];
      return;
    }

    Vector tokens = new Vector();
    StringTokenizer tok = new StringTokenizer(s, ",");
    while(tok.hasMoreTokens())
    {
      tokens.addElement(tok.nextToken().trim());
    }

    names = new String[tokens.size()];
    qualities = new double[tokens.size()];
    for(int i=0; i<names.length; i++)
    {
      String t = (String)tokens.elementAt(i);
      int sep = t.indexOf(";q=");
      if(sep == -1)
      {
	names[i] = t;
	qualities[i] = 1.0;
      }
      else
      {
	names[i] = t.substring(0,sep).trim();
	try
	{
	  qualities[i] = Double.valueOf(t.substring(sep+3)).doubleValue();
	}
	catch(NumberFormatException ignored) {}
      }
    }

    sort();
  }


  private void sort()
  {
    for(int i=0; i<qualities.length; i++)
    {
      for(int j=i+1; j<qualities.length; j++)
      {
	if(qualities[i] < qualities[j])
	{
	  double tmpq = qualities[i];
	  qualities[i] = qualities[j];
	  qualities[j] = tmpq;

	  String tmpn = names[i];
	  names[i] = names[j];
	  names[j] = tmpn;
	}
      }
    }
  }


  public int size()
  {
    return names.length;
  }


  public String nameAt(int i)
  {
    return names[i];
  }


  public double qualityAt(int i)
  {
    return qualities[i];
  }


  public int indexOf(String name)
  {
    for(int i=0; i<names.length; i++)
      if(names[i].equals(name)) return i;
    return -1;
  }


  public int indexOf(double quality)
  {
    for(int i=0; i<qualities.length; i++)
      if(qualities[i] == quality) return i;
    return -1;
  }


  public double qualityOf(String name)
  {
    int idx = indexOf(name);
    if(idx == -1) return -1.0;
    else return qualities[idx];
  }


  public static void main(String[] args)
  {
    AcceptList l = new AcceptList(args[0]);
    for(int i=0; i<l.size(); i++)
      System.out.println(l.nameAt(i)+": "+l.qualityAt(i));
  }
}
