package tapir.weeds.representation;

import honeylocust.msxml.om.Document;
import honeylocust.msxml.om.Element;
import honeylocust.msxml.om.ElementCollection;
import honeylocust.msxml.parser.ParseException;
import honeylocust.msxml.util.Name;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;


public class MSXMLSpeciesFactory {

  static final Name n_SPECIES=Name.create("species");
  static final Name n_FAMILY=Name.create("family");
  static final Name n_LATIN=Name.create("latin");
  static final Name n_COMMON=Name.create("common");
  static final Name n_TEXT=Name.create("text");
  static final Name n_A=Name.create("a");
  static final Name n_CM=Name.create("cm");
  static final Name n_REF=Name.create("ref");

  static final boolean debug=false;

  public static void parseLimon(Vector v,File f) throws Exception {
    parseLimon(v,new URL("file:"+f.getAbsolutePath()));
  };
    
  public static void parseLimon(Vector v,URL u) throws Exception {
    Document d=new Document();
    d.setLoadExternal(true);
    try {
      d.load(u);
    } catch(ParseException e) {
      d.reportError(e,System.out);
      System.exit(-1);
    };

    Element root=d.getRoot();
    ElementCollection plants=root.getChildren();

    for(int i=0;i<plants.getLength();i++) {
      Element plantElement=plants.getChild(i);
      if (plantElement.getTagName()==n_SPECIES) {
	Species species=MSXMLSpeciesFactory.parseSpecies(plantElement);
	v.addElement(species);
      };
    };

  };

  static Species parseSpecies(Element e) throws Exception {
    if (e.getTagName()!=n_SPECIES)
      throw new Exception("Element must be a SPECIES Element for second-stage parse!");

    SpeciesImpl species=new SpeciesImpl();

    species.d_id=(String) e.getAttribute("id");
    Element familyElement=getSingleChild(e,n_FAMILY);
    if (familyElement!=null)
      species.d_family=new LanguageString(familyElement.getText(),"la").intern();
    
    species.d_latin=convertToLanguageStringArray(e,n_LATIN,"la");
    species.d_common=convertToLanguageStringArray(e,n_COMMON);

    ElementCollection textElements=new ElementCollection(e,n_TEXT,-1);
    Text[] texts=new Text[textElements.getLength()];

    for(int i=0;i<textElements.getLength();i++) {
      texts[i]=parseText(textElements.getChild(i));
    };

    species.d_texts=texts;

    return species;
  };

  // Convenience method:
  // If there is only one child of a certain type, this method gets it    
  // without the bother of fussing with a Collection                      

  static Element getSingleChild(Element e,Name kind) throws Exception {
    ElementCollection ec=new ElementCollection(e,kind,-1);
    if (ec.getLength()>1)
      throw new Exception("I'm only supposed to get a single child!");

    if (ec.getLength()==0)
      return null;
    else
      return ec.getChild(0);
  };

  /* In this case there isn't any language data in the XML and all of */
  /* the strings will be in the same language */

  static LanguageString[] convertToLanguageStringArray(Element e,Name kind,String lang) throws Exception {
    ElementCollection ec=new ElementCollection(e,kind,-1);

    LanguageString[] sarray=new LanguageString[ec.getLength()];

    for(int i=0;i<ec.getLength();i++) {
      sarray[i]=new LanguageString(ec.getChild(i).getText().trim(),lang);
    };

    return sarray;
  };

  /* In this case there are xml:lang attributes and we're supposed to parse      */
  /* them.  A bug work-around is built in here.  MSXML doesn't keep track    */
  /* of default attribute values,  getAttribute() just returns null if the   */
  /* attribute isn't specified,  so we fix that here                         */
 

  static LanguageString[] convertToLanguageStringArray(Element e,Name kind) throws Exception {
    ElementCollection ec=new ElementCollection(e,kind,-1);

    LanguageString[] sarray=new LanguageString[ec.getLength()];

    for(int i=0;i<ec.getLength();i++) {
      Element child=ec.getChild(i);
      String lang=(String) child.getAttribute("xml:lang");
      if (lang==null)
         lang="en";

      sarray[i]=new LanguageString(ec.getChild(i).getText().trim(),lang);
    };

    return sarray;
  };

  public static Text parseText(Element e) {
    TextImpl text=new TextImpl();

    text.d_type=(String) e.getAttribute("type");
    text.d_source=(String) e.getAttribute("source");
    text.d_language=(String) e.getAttribute("xml:lang");

    if (debug)
      System.out.println(">>Name is "+e.getTagName());
    ElementCollection chunkElements=new ElementCollection(e,null,-1);
    text.d_chunks=new TextChunk[chunkElements.getLength()];

    if(debug) {
      System.out.println(">>Text has "+chunkElements.getLength()+" chunks");
      System.out.println(">>Text content is "+e.getText());
    };

    for(int i=0;i<chunkElements.getLength();i++) {
      Element f=chunkElements.getChild(i);
      if (f.getTagName()==n_A) {
	text.d_chunks[i]=parseAnchorChunk(f);
      } else if (f.getTagName()==n_CM) {
	text.d_chunks[i]=parseCMChunk(f);
      } else if (f.getTagName()==n_REF) {
	text.d_chunks[i]=parseRefChunk(f);
      } else
	text.d_chunks[i]=parsePlainChunk(f);

      if (debug) {
	System.out.println(">> Chunk #"+i+" is a "+text.d_chunks[i].getClass().toString());
	System.out.println("Content is "+text.d_chunks[i].getText());
      };
    };
    return text;
  };

  static PlainChunk parsePlainChunk(Element e) {
    return new PlainChunk(e.getText());
  };

  static CMChunk parseCMChunk(Element e) {
    return new CMChunk(e.getText());
  };

  static RefChunk parseRefChunk(Element e) {
    return new RefChunkImpl((String) e.getAttribute("id"));
  };

  static AnchorChunk parseAnchorChunk(Element e) {
    if (debug)
      System.err.println("Parsing Anchor Chunk");

    return new AnchorChunk(e.getText(),(String) e.getAttribute("href"));
  };


};
