import java.awt.*;
import java.applet.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;

public class DbApplet extends Applet implements ActionListener {

   TextField tfQuery;
   TextArea taResults;
   Button btnExecute;

   public void init() {

       Panel p1 = new Panel();
      p1.setLayout(new FlowLayout(FlowLayout.LEFT));

      p1.add(new Label("Query String:"));

      tfQuery = new TextField("", 50);
      p1.add(tfQuery);

      btnExecute = new Button("Execute Query");
      btnExecute.addActionListener(this);
      p1.add(btnExecute);

      add("North", p1);

      taResults = new TextArea(10, 80);
      add("Center", taResults);
   }

   public void executeQuery() {

      String qryString = tfQuery.getText();

      try {
         /* The line below can be adjusted to your local servlet position */

         URL url = new URL("http://localhost:8080/servlet/DbServlet");
         String qry = URLEncoder.encode("qry") + "=" + 
                             URLEncoder.encode(qryString);

         URLConnection uc = url.openConnection();
         uc.setDoOutput(true);
         uc.setDoInput(true);
         uc.setUseCaches(false);
         uc.setRequestProperty("Content-type", 
                             "application/x-www-form-urlencoded");
 
         DataOutputStream dos = new DataOutputStream(uc.getOutputStream());
         dos.writeBytes(qry);
         dos.flush();
         dos.close();

         InputStreamReader in = new InputStreamReader(uc.getInputStream());
 
         int chr = in.read();
         while (chr != -1) {
            taResults.append(String.valueOf((char) chr));
            chr = in.read();   
         }
         in.close();

      } catch(MalformedURLException e) {
         taResults.setText(e.toString());
      } catch(IOException e) {
         taResults.setText(e.toString());
      }
   }
   public void actionPerformed(ActionEvent ae) {
      executeQuery();
   }
}
