import java.util.*;

//   Servlet Libraries
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

import com.wrox.util.*;

public class ShoppingCart extends HttpServlet
{

   public void doPost(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException
   {

      //   Get session object
      HttpSession session = req.getSession(true);

      //   Get item count from session object
      Integer itemCount = (Integer) session.getValue("itemCount");

      //   If the session is new, "itemCount" won't exist yet
      if (itemCount == null)
      {
         itemCount = new Integer(0);
      }

      PrintWriter out = res.getWriter();
      res.setContentType("text/html");

      //   Retrieve Form Data
      String[] itemsSelected;
      String itemName;
      itemsSelected = req.getParameterValues("item");

      //   If there were items selected, add them to the session object
      if (itemsSelected != null)
      {

         //   Loop through all of the selected items
         for (int i=0 ; i < itemsSelected.length ; i++)
         {
            itemName = itemsSelected[i];
            itemCount = new Integer(itemCount.intValue() + 1);

            session.putValue("Item" + itemCount, itemName); //  store the item under name 'ItemX'
            session.putValue("itemCount", itemCount);       //  store the increased itemCount
         }
      }

      //   Print Current Contents of Cart
      HTML h = new HTML("Shopping Cart Contents");
      h.add(HTML.HEADING, "Items currently in your cart", false);
      h.add(HTML.LINE, "", false);

      for(int i = 1; i <= itemCount.intValue(); i++)
      {
         String item = (String) session.getValue("Item" + i); //  retrieve the item called 'ItemX'
         h.add(HTML.NORMAL, item, true);
      }

      //  add a link back to the shop to allow more items to be selected
      h.add(HTML.LINE, "", false);
      h.add(HTML.NORMAL, "<A HREF=\"../ShoppingCart.html\">Back to the shop</A>", true);

      out.println(h.getPage());
      out.close();
   }
}
