package com.wrox.pizza;

import java.io.*;

public class PizzaHTMLUtil 
{
   private static String formatAttr(String name, String value) 
   {
      return " " + name + "=" + '"' + value + '"';
   }
  
   public static void writeDocumentHeader(PrintWriter writer,
          String title, String action) 
   {
      writer.println("<HTML><HEAD>");
      writer.println("<TITLE>" + title + "</TITLE>");
      writer.println("</HEAD><BODY>");
      writer.println("<FORM" +
                      formatAttr("METHOD", "POST") +
                      formatAttr("ACTION", action) + ">");
   }

   public static void writeDocumentFooter(PrintWriter writer) 
   {
      writer.println("</FORM></BODY></HTML>");
   }
 
   public static void writeTableHeader(PrintWriter writer) 
   {
      writer.println("<TABLE" +
       formatAttr("BORDER", "0") +
       formatAttr("WIDTH", "100%") +
       formatAttr("CELLSPACING", "0") +
       formatAttr("CELLPADDING", "2") + ">");
   }

   public static void writeTableCell(PrintWriter writer,
                 String title, String cellContent) 
   {
      writer.println("<TR><TD>");
      writer.println("<H1" +
      PizzaHTMLUtil.formatAttr("ALIGN", "center") +
         "><FONT COLOR=#008000>" + title + "</FONT></H1>");
      writer.println("</TD></TR>");
      writer.println("<TR><TD><H3 ALIGN=center>");
      writer.println(cellContent);
      writer.println("</TD></TR></H3>");
   }
	
   public static void writeTableFooter(PrintWriter writer)
   {
      writer.println("</TABLE><HR>");
   }

   public static void writeInputField(PrintWriter writer,
          String type, String name, String value)
   {
      writeInputField(writer, type, name, value, false);
   }
  
   public static void writeInputField(PrintWriter writer,
          String type, String name, String value, boolean check) 
   {
      writer.println("<INPUT" +
       formatAttr("type", type) +
       formatAttr("name", name) +
       formatAttr("value", value) +
       (check ? formatAttr("checked", "true") : "") +
       ">");
   }

   public static void writeText(PrintWriter writer, String someText)
   {
      writer.println(someText);
   }
}
