package com.wrox.pizza;

import java.io.*;
import java.net.*;
import java.util.*;
import org.w3c.dom.*;

public class PizzaView
{
   public static void getPizzaPage(PrintWriter writer, String action, 
                     int current, PizzaMenu pizzaMenu) throws IOException  
   {

      PizzaHTMLUtil.writeDocumentHeader(writer, "temp title", action);
      PizzaHTMLUtil.writeInputField(writer, "HIDDEN", "CURRENT_PIZZA", ""
                                      + current);
      PizzaHTMLUtil.writeTableHeader(writer);
      Pizza tmpPizza = pizzaMenu.getPizza(current);
  	
      PizzaHTMLUtil.writeTableCell(writer, "Topping ", tmpPizza.getTopping());
      PizzaHTMLUtil.writeTableCell(writer, "Price ", "$" + tmpPizza.getPrice());
      PizzaHTMLUtil.writeTableCell(writer, "Size ", tmpPizza.getSize());
   	
      PizzaHTMLUtil.writeTableFooter(writer);
     
 
      if (tmpPizza.isOrdered()) 
      {
         PizzaHTMLUtil.writeInputField(writer, "CHECKBOX", "ORDER_IT", "" +
       	            current, true);
      }
      else 
      {
         PizzaHTMLUtil.writeInputField(writer, "CHECKBOX", "ORDER_IT", "" + 
  	   	            current);
      }

      PizzaHTMLUtil.writeText(writer, "Check box to order.<p>");

      if (current > 0) 
      {
         PizzaHTMLUtil.writeInputField(writer, "SUBMIT", "PREV", "PREV");
      }
      if (current < pizzaMenu.getNumOfPizza()-1) 
      {
         PizzaHTMLUtil.writeInputField(writer, "SUBMIT", "NEXT", "NEXT");
      }
      PizzaHTMLUtil.writeInputField(writer, "SUBMIT", "CHECKOUT", "CHECKOUT");

      PizzaHTMLUtil.writeDocumentFooter(writer);
      writer.flush();
   }

   public static void getOrderInfoPage(PrintWriter writer, String action)
                  throws IOException 
   {
    
      PizzaHTMLUtil.writeDocumentHeader(writer, 
                   "Enter Order Information", action);
   
      PizzaHTMLUtil.writeText(writer, "Please provide the following information to complete your order<p>");

      PizzaHTMLUtil.writeText(writer, "Your Name: ");
      PizzaHTMLUtil.writeInputField(writer, "TEXT", "NAME", "");

      PizzaHTMLUtil.writeText(writer, "<p>Phone: ");
      PizzaHTMLUtil.writeInputField(writer, "TEXT", "PHONE", "");

      PizzaHTMLUtil.writeText(writer, "<p>Address: ");
      PizzaHTMLUtil.writeInputField(writer, "TEXT", "ADDRESS", "");

      PizzaHTMLUtil.writeText(writer, "<p>");
      PizzaHTMLUtil.writeInputField(writer, "SUBMIT", "FINISH", "FINISH");
      PizzaHTMLUtil.writeInputField(writer, "SUBMIT", "FINISHXML", "FINISHXML");

      PizzaHTMLUtil.writeDocumentFooter(writer);
      writer.flush();
   }
	
   public static void getOrderPage(PrintWriter writer, String action, 
		   PizzaMenu pizzaMenu, boolean doXML) throws IOException   
   {
    
   if (!doXML) 
   {
      PizzaHTMLUtil.writeText(writer, "<HTML><HEAD><TITLE> XML Pizza Order</TITLE></HEAD>");
      PizzaHTMLUtil.writeText(writer, "<BODY><PRE>");
   }

   PizzaHTMLUtil.writeText(writer, "<?xml version=\"1.0\"?>\n");
   PizzaHTMLUtil.writeText(writer, "<pizzaorder>");
   PizzaHTMLUtil.writeText(writer, "<name>" + pizzaMenu.name + "</name>");
   PizzaHTMLUtil.writeText(writer, "<phone>" + pizzaMenu.phone + "</phone>");
   PizzaHTMLUtil.writeText(writer, "<address>" + pizzaMenu.address +
                 "</address>");

   Pizza tmpPizza = null;
   for (int i=0; i< pizzaMenu.getNumOfPizza(); i++) 
   {
      tmpPizza = pizzaMenu.getPizza(i);
      if (tmpPizza.isOrdered()) 
      {
         PizzaHTMLUtil.writeText(writer, "<pizza>");
         PizzaHTMLUtil.writeText(writer, "<topping>" + tmpPizza.getTopping() + 
                                "</topping>");
         PizzaHTMLUtil.writeText(writer, "<price>" + tmpPizza.getPrice() +
 			                            "</price>");
         PizzaHTMLUtil.writeText(writer, "<size>" + tmpPizza.getSize() +
 			                            "</size>");
         PizzaHTMLUtil.writeText(writer, "</pizza>");
      }
   }
   PizzaHTMLUtil.writeText(writer, "</pizzaorder>");
   if (!doXML) 
   {
      PizzaHTMLUtil.writeText(writer, "</PRE></BODY></HTML>");
   }
      writer.flush();
   }
}
