package data;

import java.sql.*;
import java.util.*;
import spider.Index;

/**
 *		Provides JDBC access to database for spider
 */
public class Dbspider extends Dbaccess{

	PreparedStatement addSiteSQL;
	PreparedStatement incinlinksSQL;
	PreparedStatement updatelinktextSQL;
	Statement getTopsSQL;
	Statement containsSQL; 

/**
 *		Adds a site record to db 
 */
	public void addSite(String url, String title, String description, String keywords, String pagetext, Integer inlinks, String linktext, int outlinks){
		Timestamp now = new Timestamp(System.currentTimeMillis());
		try{
// Defined in PreparedStatement
			addSiteSQL.setString(1, url); 
			addSiteSQL.setString(2, " "+title); 
			addSiteSQL.setString(3, " "+description); 
			addSiteSQL.setString(4, " "+keywords);
			addSiteSQL.setString(5, " "+pagetext);
			addSiteSQL.setInt(6, inlinks.intValue());
			addSiteSQL.setString(7, " "+linktext);
			addSiteSQL.setInt(8, outlinks);
			addSiteSQL.setTimestamp(9, now);  
			addSiteSQL.executeUpdate();
		}catch (SQLException sqle){
		 	System.out.println(sqle.toString()); 
		 }	
	}

/**
 *		Checks db for existence of record, if it finds it increments
 * 		that records INLINKS value 
 */
	public boolean checkRecord(String urlstring, String linktext, int increment){
		boolean contains = false;
		try{
			ResultSet rs = containsSQL.executeQuery("SELECT SITES.URL FROM SITES WHERE SITES.URL = '"+urlstring+"'"); 
			contains = rs.next();
			if(contains){
				incinlinksSQL.setInt(1, increment);
				incinlinksSQL.setString(2, urlstring);
				incinlinksSQL.executeUpdate();
				updatelinktextSQL.setString(1, " "+linktext);
				updatelinktextSQL.setString(2, urlstring);
				updatelinktextSQL.executeUpdate();
			}
		}catch (SQLException sqle){
		 	System.out.println(sqle.toString()); 
		 }
		return contains;
	}

/**
 *		Get the most popular sites
 */
	public Vector getTopURLs(){
		Vector tops = new Vector();
		try{
			ResultSet results = 
				getTopsSQL.executeQuery("SELECT TOP "+Index.CACHESIZE+" SITES.URL, "
			+"SITES.INLINKS FROM SITES ORDER BY SITES.INLINKS DESC");
			while (results.next()) {
				tops.add(results.getString("URL"));
			}
		}catch (SQLException sqle){
		 	System.out.println(sqle.toString()); 
		 }
		return tops;
	}

		

/**
 *		Prepares SQL statements
 */
	public void prepareSQL() {
		try{
			addSiteSQL = connection.prepareStatement("INSERT INTO SITES VALUES (?,?,?,?,?,?,?,?,?)");
								//	URL, Title, Description, Keywords, Pagetext, Inlinks, Linktext, Timestamp 
			incinlinksSQL = connection.prepareStatement("UPDATE SITES SET "+
				"SITES.INLINKS = [SITES].[INLINKS]+? WHERE SITES.URL = ? ");	
			updatelinktextSQL = connection.prepareStatement("UPDATE SITES SET "+
				"SITES.LINKTEXT = [SITES].[LINKTEXT]+? WHERE SITES.URL = ? ");	

			getTopsSQL = connection.createStatement();
			containsSQL = connection.createStatement();
			containsSQL.setMaxRows(1);
		}catch (SQLException sqle){
		 	System.out.println(sqle.toString()); 
		 }
	}
}

