package spider;

import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import java.io.*;
import data.*;

/**
 *  Index class
 */
public class Index extends HttpServlet implements Runnable{ 
	public static int sitecount = 0;
	public static int CACHESIZE = 25;
	public static int REFRESH = 100;
	public static Vector domains = new Vector();
	public static Dbspider db;
	public static Spider spider;
	public static boolean running;
	public static int qsize;
	public static long starttime = System.currentTimeMillis();
	public static long threadtime; 

    private Thread indexThread = null;
	
	public void init(ServletConfig config) throws ServletException {
		// Store the ServletConfig object and log the initialization
		super.init(config);
		// Load the database to prepare for requests
		db = new Dbspider();
		db.prepareSQL();
		spider = new Spider();   
	}
   
	public void start() {
            indexThread = new Thread(this, "Index");
            indexThread.start();        
	}

	public void run(){
		running = true;
		threadtime =  System.currentTimeMillis();
		while(running){
			qsize =Queue.getSize();
			if(qsize>0){	
				System.out.println("Queue size = "+qsize);
				spider.Crawl();
		 	} else {
				try {
					Thread.sleep(2000);
            	} catch (InterruptedException e){
            		System.out.println("Thread woken");
					}
			 }
		}
		System.out.println("Paused");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException{
		String urlstatus;
        // set header field first
        res.setContentType("text/html");

	//Get the response's PrintWriter to return text to the client.
        PrintWriter toClient = res.getWriter();

	    // Get client's query data 
        Enumeration values = req.getParameterNames();
        String name = (String)values.nextElement();
		String value = req.getParameterValues(name)[0];

		if(!running){
			start();
			System.out.println("\nStarted Indexer");
		}
		urlstatus = spider.addSeed(value);
		outputPage(res, urlstatus, value);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException{

        // set header field first
        res.setContentType("text/html");

		//Get the response's PrintWriter to return text to the client.
        PrintWriter toClient = res.getWriter();

	    // Get client's query data 
        Enumeration values = req.getParameterNames();
        String name = (String)values.nextElement();
		String value = req.getParameterValues(name)[0];
		if(value.equals("pause")) running = false;
		outputPage(res, "Command", value);
	}

	public void outputPage(HttpServletResponse res, String string1, String string2) throws IOException{
       	PrintWriter out = res.getWriter(); 
        out.println("<HEAD><TITLE> Index</TITLE></HEAD><BODY>");
        out.println("<CENTER><H2>Indexer</H2></CENTER>");
        out.println("<P><UL>");
		out.println("<LI>Time on this run : "+(new Long((System.currentTimeMillis()-threadtime)/60000)+" mins").toString());
		out.println("<LI>Total runtime : "+(new Long((System.currentTimeMillis()-starttime)/60000)+" mins").toString());
		out.println("<LI>Total pages = "+sitecount);
		out.println("<LI>Queue size = "+qsize);
		out.println("<LI>Cache size = "+CACHESIZE+" URLSs (fixed)");
		out.println("<LI>Cache refresh after "+REFRESH+" pages (fixed)");
		out.println("<LI>Domains being scanned : "+domains);
        out.println("</UL><P>");
		out.print("<P><FONT COLOR=red><B>");
		if(running){
			out.print("Running</B></FONT>&nbsp;&nbsp;");
			out.println("<A HREF=http://localhost:8080/servlet/spider.Index?command=pause><B>Pause</B></A>");
			} else {
				out.print("Paused</B></FONT>");
		}
		out.println("<P>"+string1+"       "+string2);
    	out.println("<P><FORM ACTION=http://localhost:8080/servlet/spider.Index METHOD=POST>");
		out.println("<B>Seed URL :<B>");
    	out.println("<INPUT TYPE=text NAME=query SIZE=50><BR><BR> <INPUT TYPE=submit>");
		out.println("</FORM>");
        out.println("</BODY>");
        out.close();
	}

    public String getServletInfo() {
        return "Index Servlet";
    }
}

