import java.rmi.*;
import java.rmi.registry.*;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

import com.wrox.rmi.ReverseInterface;

public class RmiServlet extends HttpServlet
{

   public void doGet(HttpServletRequest req, HttpServletResponse res)
      throws IOException, ServletException
      {

      res.setContentType("text/plain");
      PrintWriter out = res.getWriter();
 
      String val = req.getParameter("val");
 
      if (System.getSecurityManager() == null)
      {
         System.setSecurityManager(new RMISecurityManager());
      }

      try
      {
         ReverseInterface r = (ReverseInterface)Naming.lookup("//localhost:1099/Reverse");
         out.println("The opposite of " + val + " is " + r.reverseString(val) + ".");
      }
      catch (Exception e)
      {
         out.println("Error executing remote method");
         out.println(e.toString());
      }
      out.close();
   }
}
