/*
   mapDriveOrPrinter.js
   - provides wrapper functions to map network drives
     and printer shares
*/

var enmDrives = new Enumerator(objFSO.Drives);
var arrDrives = new Array;
var i = 0;

for (enmDrives.moveFirst();
     !enmDrives.atEnd();
     enmDrives.moveNext())
{
   arrDrives[i++] = enmDrives.item().DriveLetter.toLowerCase();
}


function MapDrive(sSharePath, sLetter)
{
   var bDriveInUse = false;
   sLetter = sLetter.toLowerCase();

   for (var i = 0; i < arrDrives.length; i++)
   {
      if (sLetter == arrDrives[i])
      {
         bDriveInUse = true;
         break;
      }
   }

   if (!bDriveInUse)
   {
      if (objFSO.FolderExists(sSharePath))
      {
         objNet.MapNetworkDrive(sLetter + ":", sSharePath);
      }
      else
      {
         WScript.Echo("unable to locate server share " + sSharePath);
      }
   }
}

function AddPrinter( sPrinterPath )
{
   // if printer share exists and OS == Windows NT
   // add printer and set as default
   // (Win 9x requires second arg: driver name [as string])

   if ("Windows_NT" == objSystem("OS"))
   {
      objNet.AddWindowsPrinterConnection(sPrinterPath);
   }

   objNet.SetDefaultPrinter( sPrinterPath );
}
