import java.awt.event.*; import java.util.*; import java.awt.*; import java.io.*; import java.net.*;  //***************************************************************************************************************** /**  *  * ExpliciteServeur  * <BR><BR>  * Serveur de communication gnrique avec Flash.  Toutes les communications mises et recues  * tre termines par un caractre nul ('\0')   * Tout client utilisant ce protocole marche (en thorie du moins).  * <BR><BR>  * Le serveur accepte tout message de clients connects et broadcasts (verbatim)  * ces messages  tous les clients connects.  A chaque connection/deconnection  * le serveur braodcast egalement le numero du client  via le tag : NUMCLIENTS.  *  * Usage: java ExpliciteServeur [port]  *  */  public class ExpliciteServeur {     private Vector clients = new Vector();  // liste des clients connects mis ds un vecteur     ServerSocket Serveur;                    // le serveur          /*      * Le constructeur.  
     * paramtre : le numro de port. Le serveyr "coute" les connexions sur ce port.      */     public ExpliciteServeur(int port) {         startServeur(port);     }      /**      * lance le serveur et coute (attends) les connections.      * paramtre : le numro de port. Le serveyr "coute" les connexions sur ce port.     */     private void startServeur(int port) {         writeActivite("En attente de lancement du Serveur d'explicite");                  try {             // --- cr un nouveau serveur Serveur              Serveur = new ServerSocket(port);             writeActivite("Votre Serveur Explicite a dmarr en port : " + port);             // --- tant que le serveur est en activit...             while(true) {                 // --- ...coute pour d'eventuelles nouvelles connections.                 Socket socket = Serveur.accept();                 // --- si on arrive ici c'est qu'une socket a t cre sur acceptation d'une connection                 ExpliciteCli
 ent client = new ExpliciteClient(this, socket);                 writeActivite(client.getIP() + " est connect au Serveur Explicite.");                 // --- ajoute le nouveau client  notre liste de clients                  clients.addElement(client);                 // --- lance le thread de la socket du client accept                 client.start();		                 // --- broadcast le numero du nouveau client (egal  la taille du tableau o l'on rentre les clients)                 broadcastMessage("<NUMCLIENTS>" + clients.size() + "</NUMCLIENTS>");             }         } catch(IOException ioe) {             writeActivite("Erreur sur le Serveur : Arrt du Serveur");             //tue le serveur suite  l'erreur             killServeur();         }      }      /**      * Broadcasts un message  tous les clients connects.      * Message termin par un caractre nul.      * paramtre : le message.     */     public synchronized void broadcastMessage(String message) {     
     // --- ajoute le caractre nul au message         message += '\0';                  // --- enumerate tous les clients leur envois  chacun un message.         Enumeration enum = clients.elements();         while (enum.hasMoreElements()) {             ExpliciteClient client = (ExpliciteClient)enum.nextElement();             client.send(message);         }      }      /**      * retire le client de la liste      * @param   le client  retirer.     */     public void removeClient(ExpliciteClient client) {         writeActivite(client.getIP() + " has left the Serveur.");                  // --- retire le client de la liste         clients.removeElement(client);                  // --- broadcast le nombre de clients         broadcastMessage("<NUMCLIENTS>" + clients.size() + "</NUMCLIENTS>");     }      /**      * Ecrit un message avec System.out.println au format      * [mm/dd/yy hh:mm:ss] message.      * paramtre :  activite   (le message).     */     public void writeActiv
 ite(String activite) {         // --- prend la date et l'heure courante         Calendar cal = Calendar.getInstance();         activite = "[" + cal.get(Calendar.MONTH)                   + "/" + cal.get(Calendar.DAY_OF_MONTH)                   + "/" + cal.get(Calendar.YEAR)                   + " "                   + cal.get(Calendar.HOUR_OF_DAY)                   + ":" + cal.get(Calendar.MINUTE)                   + ":" + cal.get(Calendar.SECOND)                   + "] " + activite + "\n";          // --- affiche le message         System.out.print(activite);     }      /**      * Stop le serveur.     */     private void killServeur() {         try {             // --- stop the Serveur             Serveur.close();             writeActivite("Serveur arret");         } catch (IOException ioe) {             writeActivite("Error while stopping Serveur");         }     }          public static void main(String args[]) {         // --- si le nombre d'arguments est correct         
 if(args.length == 1) {         // --- alors on crait un serveur             ExpliciteServeur myCS = new ExpliciteServeur(Integer.parseInt(args[0]));         } else {         // sinon on affiche ce qu'il faut faire             System.out.println("utilisation: java ExpliciteServeur [port]");         }     } }