/*
 * $Id: axspawn.c,v 1.1 1997/09/23 15:45:11 jreuter Exp jreuter $
 *
 * axspawn.c - perform login from ax25d.
 *
 * Copyright (c) 1997 Jrg Reuter DL1BKE (jreuter@poboxes.com)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *                
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * It might even kill your cat... ;-) 
 *
 * Status: alpha (still...)
 *
 * ==========================================================================
 * =                 THIS IS THE LIBPAM VERSION OF AXSPAWN!                 =
 * ==========================================================================
 *
 * To run this program you'll need the Linux PAM (Plugable Authentication
 * Modules) library, available from ftp.redhat.com. For more information 
 * about Linux PAM read http://www.redhat.com/linux-info/pam/
 *
 * ==========================================================================
 *
 * usage: change the "default" lines in your /usr/local/etc/ax25d.conf:
 *
 * 	default * * * * * 1 root /usr/local/sbin/axspawn axspawn
 *
 * a line like this would wait for an incoming info frame first.
 *
 * 	default * * * * * 1 root /usr/local/sbin/axspawn axspawn --wait
 *
 * The program will check if the peer is an AX.25 socket and
 * call the apropriate PAM libraries. After a succesful 
 * authentication it will do some init and start the shell.
 *
 * It uses the forkpty from libbsd.a (found after analyzing logind)
 * which has no prototype in any of my .h files.
 *
 */

#define QUEUE_DELAY 400		/* 400 msec */
#define USERPROFILE ".profile"
#define PASSWDFILE  "/etc/passwd"

#include <errno.h>

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <strings.h>
#include <ctype.h>
#include <termios.h>
#include <unistd.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <utmp.h>
#include <paths.h>
#include <syslog.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/file.h>

#ifdef HAVE_NETAX25_AX25_H
#include <netax25/ax25.h>
#else
#include <netax25/kernel_ax25.h>
#endif
#ifdef HAVE_NETROSE_ROSE_H
#include <netrose/rose.h>
#else
#include <netax25/kernel_rose.h>
#endif
#include <netax25/axlib.h>

//#include <linux/ax25.h>
//#include <linux/rose.h>
#include <security/pam_appl.h>
#include <security/pam_misc.h>


/* #include "config.h" */
//#include "axutils.h"

#define AX_PACLEN	256
#define	NETROM_PACLEN	236
#define	ROSE_PACLEN	128

#define MSG_CANNOTFORK	"Sorry, system is overloaded.\n"
#define MSG_NOPTY	"Sorry, all channels in use.\n"
#define MSG_DEBUG	"Debug\n"

#define EXITDELAY	10

int    paclen    = ROSE_PACLEN;		/* Its the shortest ie safest */

struct write_queue {
	struct write_queue *next;
	char *data;
	int  len;
};

struct write_queue *wqueue_head = NULL;
struct write_queue *wqueue_tail = NULL;
long wqueue_length = 0;

/* This one is in /usr/lib/libbsd.a, but not in bsd.h and fellows... weird. */
/* (found in logind.c)							    */

pid_t forkpty(int *, char *, void *, struct winsize *);

int _write_ax25(const char *s, int len)
{
	int k, m;
	char *p;

	p = (char *) malloc(len+1);

	if (p == NULL)
		return 0;

	m = 0;
	for (k = 0; k < len; k++)
	{
		if ( (s[k] == '\r') && ((k+1) < len) && (s[k+1] == '\n') )
			continue;
		else if (s[k] == '\n')
			p[m++] = '\r';
		else
			p[m++] = s[k];
	}
	
	if (m)
		write(1, p, m);

	free(p);
	return len;
}

int read_ax25(char *s, int size)
{
	int len = read(0, s, size);
	int k;
	
	for (k = 0; k < len; k++)
		if (s[k] == '\r') s[k] = '\n';
		
	return len;
}

/*
 *  We need to buffer the data from the pipe since bash does
 *  a fflush() on every output line. We don't want it, it's
 *  PACKET radio, isn't it?
 */

void kick_wqueue(int dummy)
{
	char *s, *p;
	struct write_queue *buf;
	
	
	if (wqueue_length == 0)
		return;

	s = (char *) malloc(wqueue_length);
	
	p = s;
	
	while (wqueue_head)
	{
		buf = wqueue_head;
		wqueue_head = buf->next;
		
		memcpy(p, buf->data, buf->len);
		p += buf->len;
		free(buf->data);
		free(buf);
	}

	_write_ax25(s, wqueue_length);
	free(s);
	wqueue_tail=NULL;
	wqueue_length=0;
}

int write_ax25(const char *s, int len)
{
	struct itimerval itv, oitv;
	struct write_queue * buf;
	
	signal(SIGALRM, SIG_IGN);

	buf = (struct write_queue *) malloc(sizeof(struct write_queue));
	if (buf == NULL)
		return 0;

	buf->data = (char *) malloc(len);
	if (buf->data == NULL)
		return 0;

	memcpy(buf->data, s, len);
	buf->len = len;
	buf->next = NULL;	
	
	if (wqueue_head == NULL)
	{
		wqueue_head = buf;
		wqueue_tail = buf;
		wqueue_length = len;
	} else {
		wqueue_tail->next = buf;
		wqueue_tail = buf;
		wqueue_length += len;
	}
	
	if (wqueue_length >= paclen)
	{
		kick_wqueue(0);
	} else {
		itv.it_interval.tv_sec = 0;
		itv.it_interval.tv_usec = 0;
		itv.it_value.tv_sec = 0;
		itv.it_value.tv_usec = QUEUE_DELAY;

		setitimer(ITIMER_REAL, &itv, &oitv);
		signal(SIGALRM, kick_wqueue);
	}
	return len;
}

static int
ax_login_conv(int num_msg, const struct pam_message **msg, struct pam_response **resp, void *appdata_ptr)
{
	int k;
	char buf[256], *s = NULL;
	struct pam_message  *m;
	struct pam_response *r;

	/*
	 * You know what? This code is UGLY!!
	 */

	k=0;
	while (num_msg--)
	{
		m = (struct pam_message *) msg[k];

		switch(m->msg_style)
		{
			case PAM_PROMPT_ECHO_ON:
			case PAM_PROMPT_ECHO_OFF:
				_write_ax25(m->msg, strlen(m->msg));
				read_ax25(buf, sizeof(buf));
				if ((s=strchr(buf, '\n')) != NULL) *s='\0';
				r = (struct pam_response *) 
					malloc(sizeof(struct pam_response));
				if (r == NULL) return PAM_AUTH_ERR;
				r->resp_retcode = 0;
				r->resp = strdup(buf);
				resp[k] = r;
				break;
			case PAM_ERROR_MSG:
			case PAM_TEXT_INFO:
				_write_ax25( m->msg, strlen(m->msg));
				break;
			default:
		}
		k++;
	}

	return PAM_SUCCESS;
}

void putwtline(struct utmp *ut)
{
	FILE *fp;
	if ((fp = fopen(_PATH_WTMP, "a+")) != NULL)
	{
		fseek(fp, 0L, SEEK_END);
		if (fwrite(ut, sizeof(struct utmp), 1, fp) != 1)
			syslog(LOG_ERR, "Ooops, I think I've just barbecued your wtmp file\n");
		fclose(fp);
	}
}

void cleanup(char *tty)
{
	struct utmp ut, *ut_line;

	setutent();
	ut.ut_type = USER_PROCESS;
	strncpy(ut.ut_id, tty + 3, sizeof(ut.ut_line));
	ut_line = getutid(&ut);

	if (ut_line != NULL) {
		ut_line->ut_type = DEAD_PROCESS;
		ut_line->ut_host[0] = '\0';
		ut_line->ut_user[0] = '\0';
		time(&ut_line->ut_time);
		pututline(ut_line);
		putwtline(ut_line);
	}
	endutent();
}


char ptyslave[20];
int child_pid;

void signal_handler(int dummy)
{
	kill(child_pid, SIGHUP);
	cleanup(ptyslave+5);
	exit(1);
}


int main(int argc, char **argv)
{	char call[20];
	char *user;
	char buf[2048];
	int  k, cnt, digits, letters, invalid, ssid, ssidcnt, addrlen;
	int  fdmaster;
	pid_t pid = -1;
	fd_set fds_read, fds_err;
	int  chargc;
	char *chargv[20];
	int envc;
	char *envp[20];
	char wait_for_tcp;
	char *protocol;
	pam_handle_t *pamh = NULL;
	int pe;
	struct utmp ut_line;
	struct passwd *pw;
	struct winsize win = { 0, 0, 0, 0};
	struct pam_conv pam_conv = { ax_login_conv, NULL };
	union {
		struct full_sockaddr_ax25 fsax25;
		struct sockaddr_rose      rose;
	} sockaddr;

	//write_ax25(MSG_DEBUG, sizeof(MSG_DEBUG));
	
	digits = letters = invalid = ssid = ssidcnt = 0;

	if (argc > 1 && (!strcmp(argv[1],"-w") || !strcmp(argv[1],"--wait")))
		wait_for_tcp = 1;
	else
		wait_for_tcp = 0;
		
	openlog("axspawn", LOG_PID, LOG_DAEMON);

	if (getuid() != 0) {
		printf("permission denied\n");
		syslog(LOG_NOTICE, "user %d tried to run axspawn\n", getuid());
		return 1;
	}

	addrlen = sizeof(struct full_sockaddr_ax25);
	k = getpeername(0, (struct sockaddr *) &sockaddr, &addrlen);
	
	if (k < 0) {
		syslog(LOG_NOTICE, "getpeername: %m\n");
		return 1;
	}

	switch (sockaddr.fsax25.fsa_ax25.sax25_family) {
		case AF_AX25:
			strcpy(call, ax25_ntoa(&sockaddr.fsax25.fsa_ax25.sax25_call));
			protocol = "AX.25";
			paclen   = AX_PACLEN;
			break;

		case AF_NETROM:
			strcpy(call, ax25_ntoa(&sockaddr.fsax25.fsa_ax25.sax25_call));
			protocol = "NET/ROM";
			paclen   = NETROM_PACLEN;
			break;

		case AF_ROSE:
			strcpy(call, ax25_ntoa(&sockaddr.rose.srose_call));
			protocol = "Rose";
			paclen   = ROSE_PACLEN;
			break;

		default:
			syslog(LOG_NOTICE, "peer is not an AX.25, NET/ROM or Rose socket\n");
			return 1;
	}
	
	syslog(LOG_INFO, "%s connect", call);

	dup2(0, 1);
	dup2(0, 2);

	if (wait_for_tcp)
		read_ax25(buf, sizeof(buf));	/* incoming TCP/IP connection? */

	if ((pe=pam_start("axspawn", call, &pam_conv, &pamh)) != PAM_SUCCESS)
		goto schluss_jetzt;
	if ((pe=pam_authenticate(pamh, 0)) != PAM_SUCCESS)
		goto schluss_jetzt;
	if ((pe=pam_acct_mgmt(pamh, 0)) != PAM_SUCCESS)
		goto schluss_jetzt;	
	if ((pe=pam_open_session(pamh, 0)) != PAM_SUCCESS)
		goto schluss_jetzt;
	if ((pe=pam_get_item(pamh, PAM_USER, (const void **) &user)) != PAM_SUCCESS)
		goto schluss_jetzt;
	
	pe=PAM_USER_UNKNOWN;
	pw = getpwnam(user);
	if (pw == NULL) goto schluss_jetzt;
	setgid(pw->pw_gid);
	initgroups(user, pw->pw_gid);

	pam_set_item(pamh, PAM_RUSER, call);
	pam_set_item(pamh, PAM_RHOST, protocol);

	if ((pe=pam_setcred(pamh, PAM_ESTABLISH_CRED)) != PAM_SUCCESS)
		goto schluss_jetzt;
	
	pam_end(pamh, 0);
	pamh = NULL;

	fcntl(1, F_SETFL, O_NONBLOCK);
	
	pid = forkpty(&fdmaster, ptyslave, NULL, &win);
	
	if (pid == 0)
	{
		struct termios termios;

        	memset((char *) &termios, 0, sizeof(termios));
        	
        	ioctl(0, TIOCSCTTY, (char *) 0);

		termios.c_iflag = ICRNL | IXOFF;
            	termios.c_oflag = OPOST | ONLCR;
                termios.c_cflag = CS8 | CREAD | CLOCAL;
                termios.c_lflag = ISIG | ICANON;
                termios.c_cc[VINTR]  = 127;
                termios.c_cc[VQUIT]  =  28;
                termios.c_cc[VERASE] =   8;
                termios.c_cc[VKILL]  =  24;
                termios.c_cc[VEOF]   =   4;
                cfsetispeed(&termios, B19200);
                cfsetospeed(&termios, B19200);
                tcsetattr(0, TCSANOW, &termios);

		/*
		 * I though one of the pam_unix_* modules would set 
		 * utmp and wtmp, but nooo.... SIGH.
		 *
		 */

		setutent();
                ut_line.ut_type = USER_PROCESS;
                ut_line.ut_pid  = getpid();
                strncpy(ut_line.ut_line, ptyslave + 5, sizeof(ut_line.ut_line));
                strncpy(ut_line.ut_id,   ptyslave + 8, sizeof(ut_line.ut_id));
                strncpy(ut_line.ut_user, user,         sizeof(ut_line.ut_user));
                strncpy(ut_line.ut_host, protocol,     sizeof(ut_line.ut_host));
                time(&ut_line.ut_time);
                ut_line.ut_addr = 0;                
                pututline(&ut_line);
                endutent();
                putwtline(&ut_line);

		setuid(pw->pw_uid);
		seteuid(pw->pw_uid);
		chdir(pw->pw_dir);

                chargc = 0;
                chargv[chargc++] = pw->pw_shell;
                chargv[chargc++] = "-login";
                chargv[chargc]   = NULL;
                
                envc = 0; 
                envp[envc] = (char *) malloc(30);
                sprintf(envp[envc++], "AXCALL=%.22s", call);
                envp[envc] = (char *) malloc(30);
                sprintf(envp[envc++], "CALL=%.24s", (char *)user);
                envp[envc] = (char *) malloc(30);
                sprintf(envp[envc++], "PROTOCOL=%.20s", protocol);
                envp[envc] = (char *) malloc(strlen(pw->pw_dir)+6);
                sprintf(envp[envc++], "HOME=%s", pw->pw_dir);
                envp[envc] = NULL;

                execve(chargv[0], chargv, envp);
        }
        else if (pid > 0)
        {
        	child_pid = 0;
        	signal(SIGHUP, signal_handler);
        	signal(SIGTERM, signal_handler);
        	signal(SIGINT, signal_handler);
        	signal(SIGQUIT, signal_handler);
 
        	while(1)
        	{
        		FD_ZERO(&fds_read);
        		FD_ZERO(&fds_err);
        		FD_SET(0, &fds_read);
        		FD_SET(0, &fds_err);
        		FD_SET(fdmaster, &fds_read);
        		FD_SET(fdmaster, &fds_err);
        		
        		k = select(fdmaster+1, &fds_read, NULL, &fds_err, NULL);
  
        		if (k > 0)
        		{
        			if (FD_ISSET(0, &fds_err) || FD_ISSET(fdmaster, &fds_err))
        				goto raus_hier;

        			if (FD_ISSET(0, &fds_read))
        			{
        				cnt = read_ax25(buf, sizeof(buf));
        				if (cnt < 0) goto raus_hier; /* Connection died */
        				write(fdmaster, buf, cnt);
        			}
        			
        			if (FD_ISSET(fdmaster, &fds_read))
        			{
        				cnt = read(fdmaster, buf, sizeof(buf));
        				if (cnt < 0) goto raus_hier; /* chield died */
        				write_ax25(buf, cnt);
        			}
        		} else 
        		if (k < 0 && errno != EINTR) goto raus_hier;
        	}
        } 
        else
        {
        	syslog(LOG_ERR, "cannot fork %m, closing connection to %s\n", call);
        	write_ax25(MSG_CANNOTFORK, sizeof(MSG_CANNOTFORK));
        	sleep(EXITDELAY);
        	return 1;
        }

/*
 * Don't show this my CS prof... ;-)
 */

raus_hier:
	kill(pid, SIGHUP);
	cleanup(ptyslave+5);
	pam_start("axspawn", call, &pam_conv, &pamh);
	if (pamh) 
	{
		pam_setcred(pamh, PAM_DELETE_CRED);
		pam_close_session(pamh, 0);
		pam_end(pamh, 0);
	}
	sleep(EXITDELAY);
	return 0;

schluss_jetzt:
	if (pamh)
	{
		pam_get_item(pamh, PAM_USER, (const void **) &user);
		pam_end(pamh, PAM_ABORT);
	} else {
		user = call;
	}

	openlog("axspawn", LOG_PID, LOG_AUTHPRIV);
	syslog(LOG_INFO, "%s access denied: %s", user, pam_strerror(pamh, pe));
	closelog();
	sleep(EXITDELAY);
	return 1;
}
