//
//  DBController.h
//  Photo Nav
//

#import <Foundation/Foundation.h>

@protocol DBWrapper

- (int) sendWithIntResultSQLCommand:(NSString *)sqlCmd;

- (BOOL) sendWithBoolResultSQLCommand:(NSString *)sqlCmd;

@end

@interface DBController : NSObject {
    id dbWrapper;
}

// constructeur de DBController
- (DBController *) init;

// destructeur de DBController
- (void) dealloc;

// mthode pour gnrer un identificateur
- (int) generateIdImage;

// mthode pour envoyer les infos d'une image dans la base
- (void) sendInfosForImage:(id)anImage withId:(int)idImage andLogin:(NSString *)login;

// fontions d'insertion d'une image dans la base :
- (int) getIdUserForImage:(id)anImage withLogin:(NSString *)login;
- (void) insertImage:(id)anImage withId:(int)idImage andIdUser:(int)idUser;
- (int) setCategoryForImage:(id)anImage;
- (void) linkImageId:(int)idImage withCategoryId:(int)idCategory;
- (void) setPriceForImage:(id)anImage withId:(int)idImage;

@end
