/* PhotoNavController */

#import <Cocoa/Cocoa.h>
#import "PhotoNavMatrix.h"

@interface PhotoNavController : NSObject
{
    IBOutlet NSTextField 	*authorField;
    IBOutlet NSPopUpButton 	*categoryMenu;
    IBOutlet NSImageView 	*currentImage;
    IBOutlet NSTextField 	*dayField;
    IBOutlet NSPopUpButton 	*monthMenu;
    IBOutlet NSTextField 	*priceField;
    IBOutlet NSTextField 	*titleField;
    IBOutlet NSTextField 	*yearField;
    
    IBOutlet PhotoNavMatrix 	*theMatrix;
    IBOutlet NSScrollView 	*theScrollView;

    IBOutlet NSPanel		*inspectorWindow;

    // Path vers le rpertoire de travail courant
    NSString*	currentWorkingDirectoryPath;

    NSMutableArray*	imagePathArray;
}
- (IBAction)callInspector:(id)sender;
- (IBAction)deleteFile:(id)sender;
- (IBAction)export2DB:(id)sender;
- (IBAction)openDirectory:(id)sender;
- (IBAction)reloadDirectory:(id)sender;

- (BOOL)validateDay:(int)day month:(int)month year:(int)year;

- (void)setupToolbar;

- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApp;
@end
