/* PhotoNavMatrix.m
   gnr par Interface Builder */

// Import des fichiers headers ncessaires
#import "PhotoNavMatrix.h"
#import "PNImageCell.h"

@implementation PhotoNavMatrix

/* initWithFrame
Initialisation de PhotonavMatrix avec la taille du rectangle dans
lequel il est contenus
*/

- (id)initWithFrame:(NSRect)frameRect
{
    // Nous voulons des cellules de type NSImageCell
    id cell = [[PNImageCell alloc] init];

    // Initialisation du NSMatrix, avec la taille, le mode de focntionnement
    // le type de cellules, aucune lignes et colonnes, nous modifierons
    //  l'affichage des images.
    [super initWithFrame:frameRect
                    mode:NSListModeMatrix
               prototype:cell
            numberOfRows:0
         numberOfColumns:0];

    // On relache l'objet qui nous permis de crer PhotonavMatrix
    [cell release];
    return self;
}

/* awakeFromNib
Excut au chargement du fichier de ressource (.nib)
On fait dans cette mthode des initialisations plus "visuelles"
*/
- (void)awakeFromNib
{
    // NSSize n'est qu'une structure C
    NSSize theSize;

    // On dfini la taille des vignettes (des cellules du matrix)
    theSize.width = 96;
    theSize.height = 96;

    // On met a jour certains paramtre du matrix, self se rfere a lui mme, PhotoNavMatrix
    
    [self setCellSize:theSize];			// taille des cellules
    [self setTarget:self];			// la cible des manipulation
    [self setAutosizesCells:YES];		// Les cellules se redimmensionnent-elle ?
    [self setSelectionByRect: YES];		// Slection rectangulaire ou par ligne complte ?
    [self setAllowsEmptySelection:NO];		// Slection vide possible ?

    NSLog(@"Dans awakeFromNib");		// Une trace affiche dans console

}

/* afficheImage
L'action principale de PhotonavMatrix, afficher les images.
On reois les chemins des images a afficher dans un tableau (NSArray)
Il suffit de parcourir le tableau et d'afficher dans les cellules
les images dont on a le chemin complet (depuis la racine /)
*/
- (IBAction)afficheImage:(id)sender imageArray:(NSArray *)theArray
{
    // Quelques initialisation de variables
    int line=0, column=0, nbOfPictures,currentImage=0;

    // Notre objet driv de NSCellImage (cf PNImageCell.h/.m)
    PNImageCell* cell;

    // Une NSImage (pour afficher l'image)
    NSImage* thePicture;

    // Un NSRect pour connatre le rectangle dans lequel s'inscrit
    // PhotonavMatrix
    NSRect matrixRect = [self frame];

    // Calculer le nombre d'image par ligne (normalement 5)
    float numberOfPicturesInARow = matrixRect.size.width /96;
    NSLog(@"NB Pictures in a row: %f",  numberOfPicturesInARow);

    // Calculer le nombre de ligne
    nbOfPictures = [theArray count];		// On obtient le nombre d'lment du tableau reus en paramtre
    int nbOfLines = (int)(nbOfPictures/numberOfPicturesInARow) +1;
    if (nbOfPictures % (int)numberOfPicturesInARow == 0)
        nbOfLines--;

    // On redimmentionne PhotoNavMatrix avec le nombre de ligne et colonnes calcul 
    [self renewRows:nbOfLines
             columns:numberOfPicturesInARow];


    // La boucle d'affichage des images
    while(currentImage < nbOfPictures)
    {
        if(column > numberOfPicturesInARow -1 ) // Si on arrive en bout de ligne
        {
            column = 0;				// on repart de la premire colonne
            ++line;				// sur la ligne en dessous
            [self addRow];			// qu'il faut ajouter  PhotonavMatrix
        }

        // On est sur une cellule, il faut positionner certaines valeur dans les variables
        // de notre objet (de type PNImageCell)
        cell = [self cellAtRow:line column:column];
        thePicture = [[NSImage alloc] initWithContentsOfFile:[theArray objectAtIndex:currentImage]];

        // Si le fichier dont on a le chemin est une image
        if([thePicture isValid])
        {
            [cell setBordered:YES];				// On dessine une bordure
            [cell setEnabled:YES];				// On peremt la slection
            [cell setImageAlignment:NSImageAlignCenter];	// On aligne en centrnt l'image dans la cellule 
            [cell setImageScaling:NSScaleProportionally];	// On a une image proportionn
            [cell setImageFrameStyle: NSImageFrameGrayBezel];	// On choisi le type de bordure
            [cell setObjectValue: thePicture];			// On met dans la cellule l'image lue

            [cell setFullImageName:[theArray objectAtIndex:currentImage]];
            [cell setTag:currentImage];				// On ajoute le tag

            [self setNeedsDisplay:YES];		// il faut afficher l'image
            column++;				// Colonne suivante
            
        }
        currentImage++;				// Image suivante
        [thePicture release];			// On relache l'objet NSImage dont on a plus besoin
    }
    [self sizeToCells];				// PhotoNavMatrix se redimmentonne pour les ascenseurs
    [self setNeedsDisplay:YES];			// On rafraichi l'affichage
}

@end
