//
// FacturationImage.java: Class file for WO Component 'FacturationImage'
// Project PhotoWeb
//
// Created by jpl on Sat Dec 14 2002
//

import com.webobjects.foundation.*;
import com.webobjects.appserver.*;
import com.webobjects.eocontrol.*;
import com.webobjects.eoaccess.*;

public class FacturationImage extends WOComponent {
    private EOEditingContext editingContextLocal;
    
    Facture facture;
    Image currentImage;
    
    public FacturationImage(WOContext context) {
        super(context);

        // L'editingContext local est embot dans celui de la session
        editingContextLocal = new EOEditingContext(session().defaultEditingContext());

        // Initialisation de la facture
        facture = new Facture();
        
        // Ajout de la facture  l'editing context local
        editingContextLocal.insertObject(facture);
        
        // On spcifie la date de cration
        facture.setDateCreation(new NSTimestamp());

        // On rcupre l'utilisateur local
        Utilisateur utilisateurLocal = (Utilisateur)EOUtilities.localInstanceOfObject(editingContextLocal, ((Session)session()).utilisateur());

        // On set l'utilisateur  la facture
        facture.setUtilisateur(utilisateurLocal);

        // On rcupre l'image locale
        Image imageLocale = (Image)EOUtilities.localInstanceOfObject(editingContextLocal, ((Session)session()).imageSelectionnee());
        
        // Ajout de l'image slectionne  la facture
        facture.addToImages(imageLocale);
    }

    public Number montantCurrentImagePourFacture() {
        return (currentImage.montantPourDate(facture.dateCreation()));
    }
    
    public WOComponent validerFacturation() {
        // On sauve l'editingContext local
        editingContextLocal.saveChanges();

        // On sauve l'editing context de la session
        session().defaultEditingContext().saveChanges();
        
        return (pageWithName("Main"));
    }

    public WOComponent annulerFacturation() {
        return (pageWithName("Main"));
    }
}
