//
// IdentificationUtilisateur.java: Class file for WO Component 'IdentificationUtilisateur'
// Project PhotoWeb
//
// Created by jpl on Thu Dec 12 2002
//

import com.webobjects.foundation.*;
import com.webobjects.appserver.*;
import com.webobjects.eocontrol.*;
import com.webobjects.eoaccess.*;

public class IdentificationUtilisateur extends WOComponent {
    String login;
    String password;
    String message;
    
    public IdentificationUtilisateur(WOContext context) {
        super(context);
    }

    public WOComponent rechercherUtilisateurPourLoginPassword() {
        if (login == null || login.trim().length() == 0 ||
            password == null || password.trim().length() == 0) {
            // Si le login / password est incorrect on le signale
            message = "Vous devez entrer un login et un password";
            return (null);
        }

        // On initialise un dictionnaire contenant les paramtres
        NSDictionary dicoParametres = new NSDictionary(new Object[] {login, password},
                                                       new Object[] {"login", "password"});

        NSArray tmpListeUtilisateurs = null;

        tmpListeUtilisateurs = EOUtilities.objectsMatchingValues(session().defaultEditingContext(), // L'editingContext
                                                                 "Utilisateur",	// L'entit cible
                                                                 dicoParametres); // Le dictionnaire de paramtres

        if (tmpListeUtilisateurs == null || tmpListeUtilisateurs.count() == 0) {
            // Si la liste est nulle ou vide, on le signale
            message = "Aucun utilisateur pour ce login / password";
            return (null);
        }

        Utilisateur tmpUtilisateur = (Utilisateur)tmpListeUtilisateurs.objectAtIndex(0);

        ((Session)session()).setUtilisateur(tmpUtilisateur);
        
        return (pageWithName("FacturationImage"));
    }
}
