// Image.java
// Created on Sat Dec 14 16:52:01 Europe/Paris 2002 by Apple EOModeler Version 5.0

import com.webobjects.foundation.*;
import com.webobjects.eocontrol.*;
import java.math.BigDecimal;
import java.util.*;
import java.io.*;

public class Image extends EOGenericRecord {
    private NSData donneesImage; // Variable prive contenant les donnes de l'image

    public Image() {
        super();
    }

    /*
     // If you implement the following constructor EOF will use it to
     // create your objects, otherwise it will use the default
     // constructor. For maximum performance, you should only
     // implement this constructor if you depend on the arguments.
     public Image(EOEditingContext context, EOClassDescription classDesc, EOGlobalID gid) {
         super(context, classDesc, gid);
     }

     // If you add instance variables to store property values you
     // should add empty implementions of the Serialization methods
     // to avoid unnecessary overhead (the properties will be
     // serialized for you in the superclass).
     private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
     }

     private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
     }
     */

    public NSData donneesImage() {
        // Si des donnes existent, on les retourne
        if (donneesImage != null) {
            return (donneesImage);
        }

        donneesImage = new NSData(bytesImage());

        return (donneesImage);
    }

    private byte[] bytesImage() {
        // Si le chemin est null, on ne retourne rien
        if (cheminImage() == null) {
            return (null);
        }

        File tmpFile = new File(cheminImage());

        // Si aucun fichier n'existe pour le chemin, on ne retourne rien
        if (!tmpFile.exists()) {
            return (null);
        }

        FileInputStream tmpInputStream = null;

        try {
            tmpInputStream = new FileInputStream(tmpFile);
        } catch (FileNotFoundException fnfe) {
            System.out.println(fnfe.getMessage());
            return (null);
        }

        int count;
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        byte[] thebytes = null;

        try {
            while ((count = tmpInputStream.read(b,0,1024)) > 0) {
                bo.write(b, 0, count);
            }

            thebytes = bo.toByteArray();
            bo.close();
        } catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }

        return (thebytes);
    }

    public String libelle() {
        return (String)storedValueForKey("libelle");
    }

    public void setLibelle(String value) {
        takeStoredValueForKey(value, "libelle");
    }

    public String cheminImage() {
        return (String)storedValueForKey("cheminImage");
    }

    public void setCheminImage(String value) {
        if (value != cheminImage()) {
            // Si le chemin est modifi, on met les donneesImage
            //  null
            donneesImage = null;
        }

        takeStoredValueForKey(value, "cheminImage");
    }

    public NSTimestamp dateCreation() {
        return (NSTimestamp)storedValueForKey("dateCreation");
    }

    public void setDateCreation(NSTimestamp value) {
        takeStoredValueForKey(value, "dateCreation");
    }

    public NSArray categories() {
        return (NSArray)storedValueForKey("categories");
    }

    public void setCategories(NSMutableArray value) {
        takeStoredValueForKey(value, "categories");
    }

    public void addToCategories(Categorie object) {
        NSMutableArray array = (NSMutableArray)categories();

        willChange();
        array.addObject(object);
    }

    public void removeFromCategories(Categorie object) {
        NSMutableArray array = (NSMutableArray)categories();

        willChange();
        array.removeObject(object);
    }

    public Number montantPourDate(NSTimestamp uneDate) {
        // Si la uneDate est null on retourne null
        if (uneDate == null) {
            return (null);
        }
        
        // On va chercher le tarif image correspondant
        
        // l'image du tarif doit tre this
        EOQualifier qualifierImage = new EOKeyValueQualifier("image", EOQualifier.QualifierOperatorEqual, this);

        // la date debut infrieure  uneDate
        EOQualifier qualifierDateDebut = new EOKeyValueQualifier("dateDebut", EOQualifier.QualifierOperatorLessThanOrEqualTo, uneDate);
        
        // La date fin suprieure  uneDate ou nulle
        EOQualifier qualifierDateFin1 = new EOKeyValueQualifier("dateFin", EOQualifier.QualifierOperatorGreaterThanOrEqualTo, uneDate);
        EOQualifier qualifierDateFin2 = new EOKeyValueQualifier("dateFin", EOQualifier.QualifierOperatorEqual, NSKeyValueCoding.NullValue);

        EOQualifier qualifierDateFin = new EOOrQualifier(new NSArray(new Object[] {qualifierDateFin1, qualifierDateFin2}));

        // On construit le qualifier final
        EOQualifier qualifierFinal = new EOAndQualifier(new NSArray(new Object[] {qualifierImage, qualifierDateDebut, qualifierDateFin}));

        // On construit la fetch specification
        EOFetchSpecification fetchSpec = new EOFetchSpecification("TarifImage", qualifierFinal, null);

        // On rcupre une liste
        NSArray tmpListe = editingContext().objectsWithFetchSpecification(fetchSpec);

        // Si la liste est nulle ou vide, on retourne null
        if (tmpListe == null || tmpListe.count() == 0) {
            return (null);
        }

        TarifImage tmpTarif = (TarifImage)tmpListe.objectAtIndex(0);

        return (tmpTarif.tarif());
    }
}
