//
// Main.java: Class file for WO Component 'Main'
// Project PhotoWeb
//
// Created by jpl on Sun Dec 01 2002
//
 
import com.webobjects.foundation.*;
import com.webobjects.appserver.*;
import com.webobjects.eocontrol.*;
import com.webobjects.eoaccess.*;

public class Main extends WOComponent {
    private NSArray listeImages;
    
    public Main(WOContext context) {
        super(context);
    }

    public NSArray listeImages() {
        if (listeImages != null) {
            return (listeImages);
        }

        // Cration du dictionnaire des paramtres de la fetch specification
        NSDictionary dictionnairesParametres = new NSDictionary(((Session)session()).dateDerniereVisite(),
                                                                "date");

        // Excution de la fetch specification et passage de notre dictionnaire de paramtres
        listeImages = EOUtilities.objectsWithFetchSpecificationAndBindings(session().defaultEditingContext(),
                                                                           "Image",
                                                                           "listeNouvellesImages",
                                                                           dictionnairesParametres);
        
        return (listeImages);
    }
}
