//
// RechercheImages.java: Class file for WO Component 'RechercheImages'
// Project PhotoWeb
//
// Created by jpl on Sun Dec 08 2002
//

import com.webobjects.foundation.*;
import com.webobjects.appserver.*;
import com.webobjects.eocontrol.*;
import com.webobjects.eoaccess.*;

public class RechercheImages extends WOComponent {
    private String critereRecherche;
    private NSArray listeImages;

    public RechercheImages(WOContext context) {
        super(context);
    }

    public String critereRecherche() {
        return (critereRecherche);
    }

    public void setCritereRecherche(String unCritere) {
        if (critereRecherche != unCritere) {
            // Si le critre a chang, on initialise listeImages  null
            listeImages = null;
        }

        critereRecherche = unCritere;
    }

    public NSArray listeImages() {
        if (listeImages != null) {
            return (listeImages);
        }

        if (critereRecherche == null || critereRecherche.trim().length() == 0) {
            // Si le critere de recherche est null on ne retourne rien
            return (null);
        }

        // Cration du qualifier de catgorie
        EOQualifier qualifierCategorie = new EOKeyValueQualifier("categories.libelle",
                                                                 EOQualifier.QualifierOperatorCaseInsensitiveLike,
                                                                 "*" +critereRecherche.toUpperCase() +"*");

        // Cration du qualifier de libell
        EOQualifier qualifierLibelle = new EOKeyValueQualifier("libelle",
                                                           EOQualifier.QualifierOperatorCaseInsensitiveLike,
                                                           "*" +critereRecherche.toUpperCase() +"*");

        // Cration du qualifier final, l'image devra rpondre  l'un ou
        // l'autre des critres
        EOOrQualifier qualifierFinal = new EOOrQualifier(new NSArray(new Object[] {qualifierCategorie, qualifierLibelle}));

        // Cration du sort ordering
        EOSortOrdering dateCreationOrdering = new EOSortOrdering("dateCreation",
                                                                 EOSortOrdering.CompareDescending);

        // Cration de la fetch specitifaction
        EOFetchSpecification fetchSpec = new EOFetchSpecification("Image", qualifierFinal, new NSArray(dateCreationOrdering));

        // Excution de la fetch specification
        listeImages = session().defaultEditingContext().objectsWithFetchSpecification(fetchSpec);
        
        return (listeImages);
    }

    public WOComponent rechercherImage() {
        return (null);
    }
}
