//
// Session.java
// Project PhotoWeb
//
// Created by jpl on Sun Dec 01 2002
//

import com.webobjects.foundation.*;
import com.webobjects.appserver.*;
import com.webobjects.eocontrol.*;

public class Session extends WOSession {
    private NSTimestamp dateDerniereVisite;
    private static final NSTimestampFormatter formatter = new NSTimestampFormatter("%d%m%Y%H%M%S");

    private Utilisateur utilisateur;
    private Image imageSelectionnee;
    
    public Session() {
        super();
        
        /* ** Put your per-session initialization code here ** */
    }

    public void sleep() {
        enregistrerDateDerniereVisite(new NSTimestamp());
    }
    
    public NSTimestamp dateDerniereVisite() {
        if (dateDerniereVisite != null) {
            // Si on a dj une date, pas besoin de la recalculer
            return (dateDerniereVisite);
        }

        if (context() == null || context().request() == null) {
            // Nous ne sommes pas dans un contexte de requte, nous ne pourrons accder
            //  la valeur du cookie
            return (null);
        }

        String tmpStr = context().request().cookieValueForKey("dateDerniereVisite");

        if (tmpStr == null) {
            // L'utilisateur n'est jamais venu,
            // On lui initialise une dateDerniereVisite  1970
            dateDerniereVisite = new NSTimestamp(0L);
            return (dateDerniereVisite);
        }

        // On dserialise la date
        try {
            dateDerniereVisite = (NSTimestamp)formatter.parseObject(tmpStr);
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        return (dateDerniereVisite);
    }

    public void enregistrerDateDerniereVisite(NSTimestamp uneDate) {
        if (context() == null || context().response() == null) {
            // Nous ne sommes pas dans un contexte de rponse, nous ne pourrons accder
            //  la valeur du cookie
            return;
        }

        String tmpStr = formatter.format(uneDate);

        WOCookie cookie = new WOCookie("dateDerniereVisite", 	// Cl
                                       tmpStr); 		// Valeur

        cookie.setExpires(null); // Attention  l'expiration

        context().response().addCookie(cookie);
    }

    public Utilisateur utilisateur() {
        return (utilisateur);
    }

    public void setUtilisateur(Utilisateur unUtilisateur) {
        utilisateur = unUtilisateur;
    }

    public Image imageSelectionnee() {
        return (imageSelectionnee);
    }

    public void setImageSelectionnee(Image uneImage) {
        imageSelectionnee = uneImage;
    }
}
