﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 10 : Le traitement de données multimédias
# Projet   : Portfolio Multimédia
# Fichier : ProjetChapitre10.fla
# Classe : Item.as, Menu.as, Vignette.as, BarreNavigation.as, controleurSimple.as et Infos.as
*/

//Définition de la classe Personne extends MovieClip
class ControleurSimple extends MovieClip {
        // Définition des attributs de la classe
	private var panneau:MovieClip;
        private var pauseOK:Boolean;
	private var depart:Number;
        private var tempsTotal:Number;
        private var unFlux:NetStream;
   
  public function remiseAZero():Void {
        this.pauseOK  = false;
	this.depart = 2;
	this.panneau.lire._visible = true;
	this.panneau.faireUnePause._visible = false;
	this.panneau.stopper._visible=false;	
  }

  private function leBoutonLire(ns:NetStream, nom:String) {
	// L'objet tmp est utilisé pour mémorisé l'adresse de l'objet 
        // sur lequel est appliqué la méthode c'est à dire ceControleur
        var tmp:ControleurSimple = this;
	tmp.panneau.lire.onRelease = function():Void { 
   		tmp.panneau.stopper._visible = true;
   		tmp.panneau.faireUnePause._visible = true;
   		this._visible = false;
   		if (tmp.pauseOK) ns.pause();
   		else ns.play(nom);    
	};
  }

  private function leBoutonPause(ns:NetStream) {
	var tmp:ControleurSimple= this;
	tmp.panneau.faireUnePause.onRelease = function():Void {
		 this._visible = false;
		 tmp.panneau.lire._visible = true;
	    	 ns.pause();
        	 tmp.pauseOK = true;
	};
  }

  private function leBoutonStop(ns:NetStream) {
	var tmp:ControleurSimple= this;
        tmp.panneau.stopper.onRelease = function():Void {
	 	tmp.remiseAZero();
        	ns.seek(tmp.depart);
		ns.pause(true);	
	};
  }


  // Définition de la fonction constructeur 
  public function ControleurSimple( nom:String) {
     var ceControleur:ControleurSimple = this;
     // Associer le panneau à l'occurrence _global.controleur
     ceControleur.panneau = _global.controleur;
     // Placer le panneau au centre du fond Photo
     ceControleur.panneau._x = _global.FdPho._width/2 ;
     ceControleur.panneau._y =_global.FdPho._height/2 ;

     // Initialiser le controleur
     ceControleur.remiseAZero();
     // Associer le flux au flux global
     ceControleur.unFlux = _global.unFluxVideo;
     // Test le status du flux
     ceControleur.unFlux.onStatus = function(infoStatus:Object):Void {
		trace( "Code reçu : " +infoStatus.code);
		if (infoStatus.code == "NetStream.Play.Stop") {
	     		this.seek(depart);
             		this.pause(true);
             		ceControleur.remiseAZero();
		}
   	};
	ceControleur.unFlux.onMetaData = function(infoData:Object):Void {
    		ceControleur.tempsTotal =  infoData.duration;
   	};

     // Associer un écran au flux vidéo
     ceControleur.panneau.laVideo.attachVideo(unFlux);
     ceControleur.unFlux.setBufferTime(depart);
     // Définir le comportement du bouton Lecture
     ceControleur.leBoutonLire(ceControleur.unFlux, nom);
     // Définir le comportement du bouton Pause
     ceControleur.leBoutonPause(ceControleur.unFlux);
     // Définir le comportement du bouton Stop
     ceControleur.leBoutonStop(ceControleur.unFlux);
  }
}

