﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 10 : Le traitement de données multimédias
# Projet   : Portfolio Multimédia
# Fichier : ProjetChapitre10.fla
# Classe : Item.as, Menu.as, Vignette.as, BarreNavigation.as, controleurSimple.as et Infos.as
*/

class Vignette extends MovieClip {
        private var photo:MovieClip;     
        private var numero:Number;
        private var rubrique:String;
        private var chemin:String;
        private var format:String;
        private var cetteVignette:Vignette;
        private var ctrl:ControleurSimple;
        public static var largeur:Number = 70;
        private static var vitesseVignette:Number = 6;
   
	
  // Définition de la fonction constructeur 
  public function Vignette( cible:MovieClip, p:Number, c:String, n:Number, r:String, f:String) {
    cetteVignette = this;
    cetteVignette.photo = cible.attachMovie("FondVignetteClp", "vignette"+p , p);
 
    cetteVignette.numero = n;
    cetteVignette.rubrique = r;
    cetteVignette.chemin = c;
    cetteVignette.format = f;
  }

  public function arreterLeDeplacement():Void {
    delete this.photo.onEnterFrame;
  }


  public function seDeplaceAGauche(numVignette:Number,btnG:MovieClip, btnD:MovieClip, lm:Number, ltv:Number ):Void {
    this.photo.onEnterFrame = function():Void {
      if (this._x < 0) btnG._visible = true;
      if (this._x <= lm - ltv + numVignette*largeur ) {
	  delete this.onEnterFrame;
	  this._x  = lm - ltv+ numVignette*largeur ;
	  btnD._visible = false;
       }
       else {
         this._x -= vitesseVignette;
       }
     } // fin onEnterFrame
  }


  public function seDeplaceADroite(numVignette:Number,btnG:MovieClip, btnD:MovieClip, lm:Number, ltv:Number ):Void {
    this.photo.onEnterFrame = function():Void {
      if (this._x < 0) btnD._visible = true;
      if (this._x >  largeur*numVignette ) {
	  delete this.onEnterFrame;
	  this._x  = largeur*numVignette;
          btnG._visible = false;
      }
      else {
         this._x += vitesseVignette;
      }
    } // fin onEnterFrame

  }

  public function sAffiche(nx:Number, ny:Number):Void {
    cetteVignette.photo._x = nx;;
    cetteVignette.photo._y = ny ;

    var chargeurImage:MovieClipLoader = new MovieClipLoader();
    chargeurImage.loadClip(cetteVignette.chemin+"/Vignette"+cetteVignette.numero+".jpg", cetteVignette.photo);
    var ecouteur:Object = new Object();
    ecouteur = cetteVignette;
    chargeurImage.addListener(ecouteur);

    ecouteur.onLoadInit = function(laPhoto:MovieClip):Void {
      var tmp:Vignette = this;
      var cadre:MovieClip;
      laPhoto.onRollOver = function():Void {
        cadre = _parent.attachMovie("BordVignetteClp","cadre", _parent.getNextHighestDepth());
        cadre._x = this._x ;
        cadre._y = this._y ; 
        this._alpha = 80;
      }

      laPhoto.onRollOut = function():Void  {     
        cadre.removeMovieClip();
        this._alpha = 100;
      }

      laPhoto.onRelease = function():Void {
        // Dès qu'une vignette est sélectionnée, arrêter le flux vidéo
        _global.unFluxVideo.pause(true);  
        _global.unFluxVideo.seek(0);

        // Afficher le texte associé à la vignette cliquée
        var texte:Infos = new Infos(_global.FdTxt ,tmp.chemin+"Infos"+tmp.numero+".txt", 5, 10)
        
        if (tmp.format == ".flv") {  
          // Le fond Photo devient invisible et le fond Vidéo visible
          _global.FdPho._visible=false;
          _global.FdVideo._visible=true;
          // Charger la vidéo associée à la vignette cliquée
          var cheminVideo:String = tmp.chemin+tmp.rubrique+tmp.numero+tmp.format;
          tmp.ctrl = new ControleurSimple(cheminVideo );
        }
        else  { 
          // Le fond Vidéo devient invisible et le fond Photo visible
          _global.FdPho._visible=true;
          _global.FdVideo._visible=false;
          // Charger la photo associée à la vignette cliquée
          _global.FdPho.loadMovie(tmp.chemin+tmp.rubrique+tmp.numero+tmp.format);
  
        }
      }
    }
  }

}
