/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.loader.CollectionInitializer;

public final class NamedQueryCollectionInitializer
implements CollectionInitializer {
    private final String queryName;
    private final CollectionPersister persister;
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$collection$NamedQueryCollectionInitializer == null ? (class$org$hibernate$collection$NamedQueryCollectionInitializer = NamedQueryCollectionInitializer.class$("org.hibernate.collection.NamedQueryCollectionInitializer")) : class$org$hibernate$collection$NamedQueryCollectionInitializer));
    static /* synthetic */ Class class$org$hibernate$collection$NamedQueryCollectionInitializer;

    public NamedQueryCollectionInitializer(String queryName, CollectionPersister persister) {
        this.queryName = queryName;
        this.persister = persister;
    }

    public void initialize(Serializable key, SessionImplementor session) throws HibernateException {
        AbstractQueryImpl query;
        if (log.isDebugEnabled()) {
            log.debug((Object)("initializing collection: " + this.persister.getRole() + " using named query: " + this.queryName));
        }
        if ((query = (AbstractQueryImpl)session.getNamedQuery(this.queryName)).getNamedParameters().length > 0) {
            query.setParameter(query.getNamedParameters()[0], (Object)key, this.persister.getKeyType());
        } else {
            query.setParameter(0, (Object)key, this.persister.getKeyType());
        }
        query.setCollectionKey(key).setFlushMode(FlushMode.NEVER).list();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

