/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class PersistentBag
extends AbstractPersistentCollection
implements List {
    private List bag;

    public PersistentBag(SessionImplementor session) {
        super(session);
    }

    public PersistentBag(SessionImplementor session, Collection coll) {
        super(session);
        if (coll instanceof List) {
            this.bag = (List)coll;
        } else {
            this.bag = new ArrayList();
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                this.bag.add(iter.next());
            }
        }
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    public PersistentBag() {
    }

    public boolean isWrapper(Object collection) {
        return this.bag == collection;
    }

    public boolean empty() {
        return this.bag.isEmpty();
    }

    public Iterator entries(CollectionPersister persister) {
        return this.bag.iterator();
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, this.getSession());
        this.bag.add(element);
        return element;
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.bag = new ArrayList();
    }

    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        EntityMode entityMode = this.getSession().getEntityMode();
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() != this.bag.size()) {
            return false;
        }
        Iterator iter = this.bag.iterator();
        while (iter.hasNext()) {
            boolean unequal;
            Object elt = iter.next();
            boolean bl = unequal = this.countOccurrences(elt, this.bag, elementType, entityMode) != this.countOccurrences(elt, sn, elementType, entityMode);
            if (!unequal) continue;
            return false;
        }
        return true;
    }

    private int countOccurrences(Object element, List list, Type elementType, EntityMode entityMode) throws HibernateException {
        Iterator iter = list.iterator();
        int result = 0;
        while (iter.hasNext()) {
            if (!elementType.isSame(element, iter.next(), entityMode)) continue;
            ++result;
        }
        return result;
    }

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        EntityMode entityMode = this.getSession().getEntityMode();
        ArrayList<Object> clonedList = new ArrayList<Object>(this.bag.size());
        Iterator iter = this.bag.iterator();
        while (iter.hasNext()) {
            clonedList.add(persister.getElementType().deepCopy(iter.next(), entityMode, persister.getFactory()));
        }
        return clonedList;
    }

    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        List sn = (List)((Object)snapshot);
        return AbstractPersistentCollection.getOrphans(sn, this.bag, entityName, this.getSession());
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = this.bag.size();
        Serializable[] result = new Serializable[length];
        int i = 0;
        while (i < length) {
            result[i] = persister.getElementType().disassemble(this.bag.get(i), this.getSession(), null);
            ++i;
        }
        return result;
    }

    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        this.beforeInitialize(persister);
        Serializable[] array = (Serializable[])disassembled;
        int i = 0;
        while (i < array.length) {
            this.bag.add(persister.getElementType().assemble(array[i], this.getSession(), owner));
            ++i;
        }
        this.setInitialized();
    }

    public boolean needsRecreate(CollectionPersister persister) {
        return !persister.isOneToMany();
    }

    /*
     * Unable to fully structure code
     */
    public Iterator getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        elementType = persister.getElementType();
        entityMode = this.getSession().getEntityMode();
        deletes = new ArrayList<E>();
        sn = (List)this.getSnapshot();
        olditer = sn.iterator();
        i = 0;
        while (olditer.hasNext()) {
            block2: {
                old = olditer.next();
                newiter = this.bag.iterator();
                found = false;
                if (this.bag.size() <= i || !elementType.isSame(old, this.bag.get(i++), entityMode)) ** GOTO lbl17
                found = true;
                break block2;
lbl-1000:
                // 1 sources

                {
                    if (!elementType.isSame(old, newiter.next(), entityMode)) continue;
                    found = true;
                    break;
lbl17:
                    // 2 sources

                    ** while (newiter.hasNext())
                }
            }
            if (found) continue;
            deletes.add(old);
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        EntityMode entityMode = this.getSession().getEntityMode();
        if (sn.size() > i && elemType.isSame(sn.get(i), entry, entityMode)) {
            return false;
        }
        Iterator olditer = sn.iterator();
        while (olditer.hasNext()) {
            Object old = olditer.next();
            if (!elemType.isSame(old, entry, entityMode)) continue;
            return false;
        }
        return true;
    }

    public boolean isRowUpdatePossible() {
        return false;
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) {
        return false;
    }

    public int size() {
        this.read();
        return this.bag.size();
    }

    public boolean isEmpty() {
        this.read();
        return this.bag.isEmpty();
    }

    public boolean contains(Object o) {
        this.read();
        return this.bag.contains(o);
    }

    public Iterator iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy(this.bag.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.bag.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.read();
        return this.bag.toArray(a);
    }

    public boolean add(Object o) {
        if (!this.queueAdd(o)) {
            this.write();
            return this.bag.add(o);
        }
        return true;
    }

    public boolean remove(Object o) {
        this.write();
        return this.bag.remove(o);
    }

    public boolean containsAll(Collection c) {
        this.read();
        return this.bag.containsAll(c);
    }

    public boolean addAll(Collection c) {
        if (c.size() == 0) {
            return false;
        }
        if (!this.queueAddAll(c)) {
            this.write();
            return this.bag.addAll(c);
        }
        return c.size() > 0;
    }

    public void delayedAddAll(Collection c) {
        this.bag.addAll(c);
    }

    public boolean removeAll(Collection c) {
        if (c.size() > 0) {
            this.write();
            return this.bag.removeAll(c);
        }
        return false;
    }

    public boolean retainAll(Collection c) {
        this.write();
        return this.bag.retainAll(c);
    }

    public void clear() {
        this.write();
        this.bag.clear();
    }

    public Object getIndex(Object entry, int i, CollectionPersister persister) {
        throw new UnsupportedOperationException("Bags don't have indexes");
    }

    public Object getElement(Object entry) {
        return entry;
    }

    public Object getSnapshotElement(Object entry, int i) {
        List sn = (List)((Object)this.getSnapshot());
        return sn.get(i);
    }

    public int occurrences(Object o) {
        this.read();
        Iterator iter = this.bag.iterator();
        int result = 0;
        while (iter.hasNext()) {
            if (!o.equals(iter.next())) continue;
            ++result;
        }
        return result;
    }

    public void add(int i, Object o) {
        this.write();
        this.bag.add(i, o);
    }

    public boolean addAll(int i, Collection c) {
        if (c.size() > 0) {
            this.write();
            return this.bag.addAll(i, c);
        }
        return false;
    }

    public Object get(int i) {
        this.read();
        return this.bag.get(i);
    }

    public int indexOf(Object o) {
        this.read();
        return this.bag.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        this.read();
        return this.bag.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.bag.listIterator());
    }

    public ListIterator listIterator(int i) {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.bag.listIterator(i));
    }

    public Object remove(int i) {
        this.write();
        return this.bag.remove(i);
    }

    public Object set(int i, Object o) {
        this.write();
        return this.bag.set(i, o);
    }

    public List subList(int start, int end) {
        this.read();
        return new AbstractPersistentCollection.ListProxy(this.bag.subList(start, end));
    }

    public String toString() {
        this.read();
        return this.bag.toString();
    }

    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

