/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.PoolConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;

public class C3P0ConnectionProvider
implements ConnectionProvider {
    private DataSource ds;
    private Integer isolation;
    private boolean autocommit;
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.connection.C3P0ConnectionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Connection getConnection() throws SQLException {
        Connection c = this.ds.getConnection();
        if (this.isolation != null) {
            c.setTransactionIsolation(this.isolation);
        }
        if (c.getAutoCommit() != this.autocommit) {
            c.setAutoCommit(this.autocommit);
        }
        return c;
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void configure(Properties props) throws HibernateException {
        String jdbcDriverClass = props.getProperty("hibernate.connection.driver_class");
        String jdbcUrl = props.getProperty("hibernate.connection.url");
        Properties connectionProps = ConnectionProviderFactory.getConnectionProperties(props);
        log.info((Object)("C3P0 using driver: " + jdbcDriverClass + " at URL: " + jdbcUrl));
        log.info((Object)("Connection properties: " + PropertiesHelper.maskOut(connectionProps, "password")));
        this.autocommit = PropertiesHelper.getBoolean("hibernate.connection.autocommit", props);
        log.info((Object)("autocommit mode: " + this.autocommit));
        if (jdbcDriverClass == null) {
            log.warn((Object)"No JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(jdbcDriverClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    ReflectHelper.classForName(jdbcDriverClass);
                }
                catch (ClassNotFoundException e) {
                    String msg = "JDBC Driver class not found: " + jdbcDriverClass;
                    log.fatal((Object)msg, (Throwable)e);
                    throw new HibernateException(msg, e);
                }
            }
        }
        try {
            int minPoolSize = PropertiesHelper.getInt("hibernate.c3p0.min_size", props, 1);
            int maxPoolSize = PropertiesHelper.getInt("hibernate.c3p0.max_size", props, 100);
            int maxIdleTime = PropertiesHelper.getInt("hibernate.c3p0.timeout", props, 0);
            int maxStatements = PropertiesHelper.getInt("hibernate.c3p0.max_statements", props, 0);
            int acquireIncrement = PropertiesHelper.getInt("hibernate.c3p0.acquire_increment", props, 1);
            int idleTestPeriod = PropertiesHelper.getInt("hibernate.c3p0.idle_test_period", props, 0);
            PoolConfig pcfg = new PoolConfig();
            pcfg.setInitialPoolSize(minPoolSize);
            pcfg.setMinPoolSize(minPoolSize);
            pcfg.setMaxPoolSize(maxPoolSize);
            pcfg.setAcquireIncrement(acquireIncrement);
            pcfg.setMaxIdleTime(maxIdleTime);
            pcfg.setMaxStatements(maxStatements);
            pcfg.setIdleConnectionTestPeriod(idleTestPeriod);
            DataSource unpooled = DataSources.unpooledDataSource((String)jdbcUrl, (Properties)connectionProps);
            this.ds = DataSources.pooledDataSource((DataSource)unpooled, (PoolConfig)pcfg);
        }
        catch (Exception e) {
            log.fatal((Object)"could not instantiate C3P0 connection pool", (Throwable)e);
            throw new HibernateException("Could not instantiate C3P0 connection pool", e);
        }
        String i = props.getProperty("hibernate.connection.isolation");
        if (i == null) {
            this.isolation = null;
        } else {
            this.isolation = new Integer(i);
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString(this.isolation)));
        }
    }

    public void close() {
        try {
            DataSources.destroy((DataSource)this.ds);
        }
        catch (SQLException sqle) {
            log.warn((Object)"could not destroy C3P0 connection pool", (Throwable)sqle);
        }
    }
}

