/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.TypeNames;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.SQLStateConverter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.sql.ANSICaseFragment;
import org.hibernate.sql.ANSIJoinFragment;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public abstract class Dialect {
    private static final Log log;
    static final String DEFAULT_BATCH_SIZE = "15";
    static final String NO_BATCH = "0";
    private static final Map STANDARD_AGGREGATE_FUNCTIONS;
    private final TypeNames typeNames = new TypeNames();
    private final Properties properties = new Properties();
    private final Map sqlFunctions = new HashMap();
    public static final String QUOTE = "`\"[";
    public static final String CLOSED_QUOTE = "`\"]";
    private static final ViolatedConstraintNameExtracter EXTRACTER;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.dialect.Dialect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        STANDARD_AGGREGATE_FUNCTIONS = new HashMap();
        STANDARD_AGGREGATE_FUNCTIONS.put("count", new StandardSQLFunction("count"){

            public Type getReturnType(Type columnType, Mapping mapping) {
                return Hibernate.INTEGER;
            }
        });
        STANDARD_AGGREGATE_FUNCTIONS.put("avg", new StandardSQLFunction("avg"){

            public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
                int[] sqlTypes;
                try {
                    sqlTypes = columnType.sqlTypes(mapping);
                }
                catch (MappingException me) {
                    throw new QueryException(me);
                }
                if (sqlTypes.length != 1) {
                    throw new QueryException("multi-column type in avg()");
                }
                int sqlType = sqlTypes[0];
                if (sqlType == 4 || sqlType == -5 || sqlType == -6) {
                    return Hibernate.FLOAT;
                }
                return columnType;
            }
        });
        STANDARD_AGGREGATE_FUNCTIONS.put("max", new StandardSQLFunction("max"));
        STANDARD_AGGREGATE_FUNCTIONS.put("min", new StandardSQLFunction("min"));
        STANDARD_AGGREGATE_FUNCTIONS.put("sum", new StandardSQLFunction("sum"));
        EXTRACTER = new ViolatedConstraintNameExtracter(){

            public String extractConstraintName(SQLException sqle) {
                return null;
            }
        };
    }

    protected Dialect() {
        log.info((Object)("Using dialect: " + this));
        this.sqlFunctions.putAll(STANDARD_AGGREGATE_FUNCTIONS);
        this.registerFunction("substring", new SQLFunctionTemplate(Hibernate.STRING, "substring(?1, ?2, ?3)"));
        this.registerFunction("length", new SQLFunctionTemplate(Hibernate.INTEGER, "length(?1)"));
        this.registerFunction("locate", new SQLFunctionTemplate(Hibernate.INTEGER, "locate(?1, ?2, ?3)"));
        this.registerFunction("abs", new SQLFunctionTemplate(Hibernate.DOUBLE, "abs(?1)"));
        this.registerFunction("sqrt", new SQLFunctionTemplate(Hibernate.DOUBLE, "sqrt(?1)"));
        this.registerFunction("trim", new SQLFunctionTemplate(Hibernate.STRING, "trim(?1 ?2 ?3 ?4)"));
        this.registerFunction("bit_length", new SQLFunctionTemplate(Hibernate.INTEGER, "BIT_LENGTH(?1)"));
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getTypeName(int code) throws HibernateException {
        String result = this.typeNames.get(code);
        if (result == null) {
            throw new HibernateException("No default type mapping for (java.sql.Types) " + code);
        }
        return result;
    }

    public String getTypeName(int code, int length, int precision) throws HibernateException {
        String result = this.typeNames.get(code, length, precision);
        if (result == null) {
            throw new HibernateException("No type mapping for java.sql.Types code: " + code + ", length: " + length);
        }
        return result;
    }

    protected void registerFunction(String name, SQLFunction function) {
        this.sqlFunctions.put(name, function);
    }

    protected void registerColumnType(int code, int capacity, String name) {
        this.typeNames.put(code, capacity, name);
    }

    protected void registerColumnType(int code, String name) {
        this.typeNames.put(code, name);
    }

    public boolean hasAlterTable() {
        return true;
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public boolean forUpdateOfColumns() {
        return false;
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString();
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString(aliases);
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString();
    }

    public boolean supportsUnique() {
        return true;
    }

    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return true;
    }

    public String getAddColumnString() {
        throw new UnsupportedOperationException("No add column syntax supported by Dialect");
    }

    public String getDropForeignKeyString() {
        return " drop constraint ";
    }

    public String getTableTypeString() {
        return "";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey) {
        return new StringBuffer(30).append(" add constraint ").append(constraintName).append(" foreign key (").append(StringHelper.join(", ", foreignKey)).append(") references ").append(referencedTable).toString();
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint " + constraintName + " primary key ";
    }

    public String getNullColumnString() {
        return "";
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsInsertSelectIdentity() {
        return false;
    }

    public String appendIdentitySelectToInsert(String insertString) {
        return insertString;
    }

    protected String getIdentitySelectString() throws MappingException {
        throw new MappingException("Dialect does not support identity key generation");
    }

    public String getIdentitySelectString(String table, String column, int type) throws MappingException {
        return this.getIdentitySelectString();
    }

    protected String getIdentityColumnString() throws MappingException {
        throw new MappingException("Dialect does not support identity key generation");
    }

    public String getIdentityColumnString(int type) throws MappingException {
        return this.getIdentityColumnString();
    }

    public String getIdentityInsertString() {
        return null;
    }

    public String getNoColumnsInsertString() {
        return "values ( )";
    }

    public String getSequenceNextValString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    protected String getCreateSequenceString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String[] getCreateSequenceStrings(String sequenceName) throws MappingException {
        return new String[]{this.getCreateSequenceString(sequenceName)};
    }

    protected String getDropSequenceString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String[] getDropSequenceStrings(String sequenceName) throws MappingException {
        return new String[]{this.getDropSequenceString(sequenceName)};
    }

    public String getQuerySequencesString() {
        return null;
    }

    public static Dialect getDialect() throws HibernateException {
        String dialectName = Environment.getProperties().getProperty("hibernate.dialect");
        if (dialectName == null) {
            throw new HibernateException("The dialect was not set. Set the property hibernate.dialect.");
        }
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", e);
        }
    }

    public static Dialect getDialect(Properties props) throws HibernateException {
        String dialectName = props.getProperty("hibernate.dialect");
        if (dialectName == null) {
            return Dialect.getDialect();
        }
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", e);
        }
    }

    public final Properties getDefaultProperties() {
        return this.properties;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public JoinFragment createOuterJoinFragment() {
        return new ANSIJoinFragment();
    }

    public CaseFragment createCaseFragment() {
        return new ANSICaseFragment();
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    public String getLimitString(String querySelect, boolean hasOffset) {
        throw new UnsupportedOperationException("paged queries not supported");
    }

    public String getLimitString(String querySelect, int offset, int limit) {
        return this.getLimitString(querySelect, offset > 0);
    }

    public boolean supportsVariableLimit() {
        return this.supportsLimit();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return false;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public final Map getFunctions() {
        return this.sqlFunctions;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public char getSchemaSeparator() {
        return '.';
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean hasDataTypeInIdentityColumn() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public String appendLockHint(LockMode mode, String tableName) {
        return tableName;
    }

    public Class getNativeIdentifierGeneratorClass() {
        if (this.supportsIdentityColumns()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.hibernate.id.IdentityGenerator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (this.supportsSequences()) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.hibernate.id.SequenceGenerator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.hibernate.id.TableHiLoGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public String getSelectGUIDString() {
        throw new UnsupportedOperationException("dialect does not support GUIDs");
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getSelectClauseNullString(int sqlType) {
        return "null";
    }

    public SQLExceptionConverter buildSQLExceptionConverter() {
        return new SQLStateConverter(this.getViolatedConstraintNameExtracter());
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public final String quote(String column) {
        if (column.charAt(0) == '`') {
            return String.valueOf(this.openQuote()) + column.substring(1, column.length() - 1) + this.closeQuote();
        }
        return column;
    }

    public boolean hasSelfReferentialForeignKeyBug() {
        return false;
    }

    public boolean useInputStreamToInsertBlob() {
        return true;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " does not support resultsets via out parameters.");
    }
}

