/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.event.SessionEventSource;
import org.hibernate.persister.EntityPersister;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

public final class CacheEntry
implements Serializable {
    private final Serializable[] state;
    private final String subclass;
    private final boolean lazyPropertiesAreUnfetched;

    public String getSubclass() {
        return this.subclass;
    }

    public boolean areLazyPropertiesUnfetched() {
        return this.lazyPropertiesAreUnfetched;
    }

    public CacheEntry(Object object, EntityPersister persister, boolean unfetched, SessionImplementor session) throws HibernateException {
        this.state = CacheEntry.disassemble(object, persister, session);
        this.subclass = persister.getEntityName();
        this.lazyPropertiesAreUnfetched = unfetched;
    }

    CacheEntry(Serializable[] state, String subclass, boolean unfetched) {
        this.state = state;
        this.subclass = subclass;
        this.lazyPropertiesAreUnfetched = unfetched;
    }

    private static Serializable[] disassemble(Object object, EntityPersister persister, SessionImplementor session) throws HibernateException {
        return TypeFactory.disassemble((Object[])persister.getPropertyValues(object), (Type[])persister.getPropertyTypes(), (SessionImplementor)session);
    }

    public Object[] assemble(Object instance, Serializable id, EntityPersister persister, Interceptor interceptor, SessionImplementor session) throws HibernateException {
        if (!persister.getEntityName().equals(this.subclass)) {
            throw new AssertionFailure("Tried to assemble a different subclass instance");
        }
        return CacheEntry.assemble(this.state, instance, id, persister, interceptor, session);
    }

    private static Object[] assemble(Serializable[] values, Object result, Serializable id, EntityPersister persister, Interceptor interceptor, SessionImplementor session) throws HibernateException {
        Object[] assembledProps = TypeFactory.assemble(values, persister.getPropertyTypes(), session, result);
        SessionEventSource source = (SessionEventSource)session;
        PreLoadEvent preLoadEvent = new PreLoadEvent(result, assembledProps, id, persister, source);
        source.getListeners().getPreLoadEventListener().onPreLoad(preLoadEvent);
        persister.setPropertyValues(result, assembledProps);
        return assembledProps;
    }

    public Serializable[] getState() {
        return this.state;
    }

    public String toString() {
        return "CacheEntry(" + this.subclass + ')' + ArrayHelper.toString(this.getState());
    }
}

