/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionSnapshot;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.util.CollectionHelper;

public final class CollectionEntry
implements CollectionSnapshot,
Serializable {
    private static final Log log;
    private boolean dirty;
    private transient boolean reached;
    private transient boolean processed;
    private transient boolean doupdate;
    private transient boolean doremove;
    private transient boolean dorecreate;
    private transient boolean ignore;
    private boolean initialized;
    private transient CollectionPersister currentPersister;
    private transient Serializable currentKey;
    private transient CollectionPersister loadedPersister;
    private Serializable loadedKey;
    private Serializable snapshot;
    private String role;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.engine.CollectionEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public CollectionEntry() {
        this.dirty = false;
        this.initialized = true;
        this.ignore = false;
    }

    CollectionEntry(CollectionPersister loadedPersister, Serializable loadedKey) {
        this(loadedPersister, loadedKey, false);
    }

    CollectionEntry(CollectionPersister loadedPersister, Serializable loadedKey, boolean ignore) {
        this.dirty = false;
        this.initialized = false;
        this.ignore = ignore;
        this.loadedKey = loadedKey;
        this.setLoadedPersister(loadedPersister);
    }

    CollectionEntry(CollectionSnapshot cs, SessionFactoryImplementor factory) throws MappingException {
        this.dirty = cs.getDirty();
        this.initialized = true;
        this.ignore = false;
        this.loadedKey = cs.getKey();
        this.setLoadedPersister(factory.getCollectionPersister(cs.getRole()));
        this.snapshot = cs.getSnapshot();
    }

    private boolean isDirty(PersistentCollection coll) throws HibernateException {
        if (this.isDirty()) {
            return true;
        }
        if (!coll.isDirectlyAccessible() && !this.getLoadedPersister().getElementType().isMutable()) {
            return false;
        }
        return !coll.equalsSnapshot(this.getLoadedPersister());
    }

    public void preFlush(PersistentCollection collection) throws HibernateException {
        boolean bl = this.dirty = this.isInitialized() && this.getLoadedPersister() != null && this.isDirty(collection) || !this.isInitialized() && this.isDirty();
        if (log.isDebugEnabled() && this.isDirty() && this.getLoadedPersister() != null) {
            log.debug((Object)("Collection dirty: " + MessageHelper.collectionInfoString(this.getLoadedPersister().getRole(), this.getLoadedKey())));
        }
        this.setDoupdate(false);
        this.setDoremove(false);
        this.setDorecreate(false);
        this.setReached(false);
        this.setProcessed(false);
    }

    public void postInitialize(PersistentCollection collection) throws HibernateException {
        this.initialized = true;
        this.snapshot = collection.getSnapshot(this.getLoadedPersister());
    }

    public boolean postFlush(PersistentCollection collection) throws HibernateException {
        if (this.isIgnore()) {
            this.ignore = false;
        } else {
            if (!this.isProcessed()) {
                throw new AssertionFailure("collection was not processed by flush()");
            }
            this.loadedKey = this.getCurrentKey();
            this.setLoadedPersister(this.getCurrentPersister());
            this.dirty = false;
            collection.postFlush();
            if (this.isInitialized() && (this.isDoremove() || this.isDorecreate() || this.isDoupdate())) {
                this.initSnapshot(collection, this.getLoadedPersister());
            }
        }
        return this.getLoadedPersister() == null;
    }

    public void initSnapshot(PersistentCollection collection, CollectionPersister persister) throws HibernateException {
        this.snapshot = collection.getSnapshot(persister);
    }

    public boolean getDirty() {
        return this.isDirty();
    }

    public Serializable getKey() {
        return this.getLoadedKey();
    }

    public String getRole() {
        return this.role;
    }

    public Serializable getSnapshot() {
        return this.snapshot;
    }

    public boolean snapshotIsEmpty() {
        return this.isInitialized() && this.getSnapshot() != null && (this.getSnapshot() instanceof Collection && ((Collection)((Object)this.getSnapshot())).size() == 0 || this.getSnapshot() instanceof Map && ((Map)((Object)this.getSnapshot())).size() == 0 || this.getSnapshot().getClass().isArray() && Array.getLength(this.getSnapshot()) == 0);
    }

    public void setDirty() {
        this.dirty = true;
    }

    void setLoadedPersister(CollectionPersister persister) {
        this.loadedPersister = persister;
        this.setRole(persister == null ? null : persister.getRole());
    }

    public boolean isNew() {
        return this.isInitialized() && this.getSnapshot() == null;
    }

    public boolean wasDereferenced() {
        return this.getLoadedKey() == null;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isReached() {
        return this.reached;
    }

    public void setReached(boolean reached) {
        this.reached = reached;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isDoupdate() {
        return this.doupdate;
    }

    public void setDoupdate(boolean doupdate) {
        this.doupdate = doupdate;
    }

    public boolean isDoremove() {
        return this.doremove;
    }

    public void setDoremove(boolean doremove) {
        this.doremove = doremove;
    }

    public boolean isDorecreate() {
        return this.dorecreate;
    }

    public void setDorecreate(boolean dorecreate) {
        this.dorecreate = dorecreate;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public CollectionPersister getCurrentPersister() {
        return this.currentPersister;
    }

    public void setCurrentPersister(CollectionPersister currentPersister) {
        this.currentPersister = currentPersister;
    }

    public Serializable getCurrentKey() {
        return this.currentKey;
    }

    public void setCurrentKey(Serializable currentKey) {
        this.currentKey = currentKey;
    }

    public CollectionPersister getLoadedPersister() {
        return this.loadedPersister;
    }

    public Serializable getLoadedKey() {
        return this.loadedKey;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String toString() {
        String result = "CollectionEntry" + MessageHelper.collectionInfoString(this.loadedPersister.getRole(), this.loadedKey);
        if (this.currentPersister != null) {
            result = String.valueOf(result) + "->" + MessageHelper.collectionInfoString(this.currentPersister.getRole(), this.currentKey);
        }
        return result;
    }

    public boolean isInitializedAndDirty() {
        return this.isInitialized() && this.isDirty();
    }

    public Collection getOrphans(String entityName, PersistentCollection coll) throws HibernateException {
        return this.isNew() ? CollectionHelper.EMPTY_COLLECTION : coll.getOrphans(this.getSnapshot(), entityName);
    }
}

