/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.LockMode;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;

public final class EntityEntry
implements Serializable {
    private LockMode lockMode;
    private Status status;
    private Serializable id;
    private Object[] loadedState;
    private Object[] deletedState;
    private boolean existsInDatabase;
    private Object version;
    private transient EntityPersister persister;
    private EntityMode entityMode;
    private String entityName;
    private boolean isBeingReplicated;
    private transient Object rowId;

    EntityEntry(Status status, Object[] loadedState, Object rowId, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, EntityMode entityMode, boolean disableVersionIncrement) {
        this.status = status;
        this.loadedState = loadedState;
        this.id = id;
        this.rowId = rowId;
        this.existsInDatabase = existsInDatabase;
        this.version = version;
        this.lockMode = lockMode;
        this.isBeingReplicated = disableVersionIncrement;
        this.persister = persister;
        this.entityMode = entityMode;
        if (persister != null) {
            this.entityName = persister.getEntityName();
        }
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public Status getStatus() {
        return this.status;
    }

    void setStatus(Status status) {
        this.status = status;
    }

    public Serializable getId() {
        return this.id;
    }

    public Object[] getLoadedState() {
        return this.loadedState;
    }

    public Object[] getDeletedState() {
        return this.deletedState;
    }

    public void setDeletedState(Object[] deletedState) {
        this.deletedState = deletedState;
    }

    public boolean isExistsInDatabase() {
        return this.existsInDatabase;
    }

    public void setExistsInDatabase(boolean existsInDatabase) {
        this.existsInDatabase = existsInDatabase;
    }

    public Object getVersion() {
        return this.version;
    }

    public EntityPersister getPersister() {
        return this.persister;
    }

    void setPersister(EntityPersister persister) {
        this.persister = persister;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean isBeingReplicated() {
        return this.isBeingReplicated;
    }

    public Object getRowId() {
        return this.rowId;
    }

    public void postUpdate(Object obj, Object[] updatedState, Object nextVersion) {
        this.loadedState = updatedState;
        this.setLockMode(LockMode.WRITE);
        if (this.getPersister().isVersioned()) {
            this.version = nextVersion;
            this.getPersister().setPropertyValue(obj, this.getPersister().getVersionProperty(), nextVersion, this.entityMode);
        }
    }

    public boolean isNullifiable(boolean earlyInsert, SessionImplementor session) {
        return this.getStatus() == Status.SAVING || !(earlyInsert ? this.isExistsInDatabase() : !session.getPersistenceContext().getNullifiableEntityKeys().contains(new EntityKey(this.getId(), this.getPersister(), this.entityMode)));
    }

    public Object getLoadedValue(String propertyName) {
        return this.loadedState[((UniqueKeyLoadable)this.persister).getPropertyIndex(propertyName)];
    }

    public String toString() {
        return "EntityEntry" + MessageHelper.infoString(this.entityName, this.id) + '(' + this.status + ')';
    }
}

