/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.Collection;
import org.hibernate.engine.QueryParameters;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.util.StringHelper;

public class Subquery {
    private final Collection resultingEntityKeys;
    private final String queryString;
    private final String alias;
    private final String[] identifierColumnNames;
    private final QueryParameters queryParameters;

    public Subquery(String queryString, String alias, Loadable loadable, QueryParameters queryParameters, Collection resultingEntityKeys) {
        this.resultingEntityKeys = resultingEntityKeys;
        this.queryParameters = queryParameters;
        this.queryString = queryString;
        this.identifierColumnNames = loadable.getIdentifierColumnNames();
        this.alias = alias;
    }

    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    public Collection getResult() {
        return this.resultingEntityKeys;
    }

    public String toSubqueryString() {
        int fromIndex = this.queryString.indexOf(" from ");
        int orderByIndex = this.queryString.indexOf("order by");
        return "select " + StringHelper.join(", ", StringHelper.qualify(this.alias, this.identifierColumnNames)) + (orderByIndex > 0 ? this.queryString.substring(fromIndex, orderByIndex) : this.queryString.substring(fromIndex));
    }
}

