/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionRecreateAction;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.action.CollectionUpdateAction;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.Collections;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.AbstractEventListener;
import org.hibernate.event.FlushEntityEvent;
import org.hibernate.event.FlushEvent;
import org.hibernate.event.SessionEventSource;
import org.hibernate.impl.CollectionEntry;
import org.hibernate.impl.EntityEntry;
import org.hibernate.impl.Status;
import org.hibernate.persister.EntityPersister;
import org.hibernate.pretty.Printer;
import org.hibernate.util.IdentityMap;

public abstract class AbstractFlushingEventListener
extends AbstractEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$AbstractFlushingEventListener == null ? (class$org$hibernate$event$AbstractFlushingEventListener = AbstractFlushingEventListener.class$("org.hibernate.event.AbstractFlushingEventListener")) : class$org$hibernate$event$AbstractFlushingEventListener));
    static /* synthetic */ Class class$org$hibernate$event$AbstractFlushingEventListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushEverythingToExecutions(FlushEvent event) throws HibernateException {
        log.trace((Object)"flushing session");
        SessionEventSource session = event.getSource();
        session.getInterceptor().preFlush(session.getEntitiesByKey().values().iterator());
        this.prepareEntityFlushes(session);
        this.prepareCollectionFlushes(session);
        session.setFlushing(true);
        try {
            this.flushEntities(event);
            this.flushCollections(session);
        }
        finally {
            session.setFlushing(false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Flushed: " + session.getActionQueue().numberOfInsertions() + " insertions, " + session.getActionQueue().numberOfUpdates() + " updates, " + session.getActionQueue().numberOfDeletions() + " deletions to " + session.getEntityEntries().size() + " objects"));
            log.debug((Object)("Flushed: " + session.getActionQueue().numberOfCollectionCreations() + " (re)creations, " + session.getActionQueue().numberOfCollectionUpdates() + " updates, " + session.getActionQueue().numberOfCollectionRemovals() + " removals to " + session.getCollectionEntries().size() + " collections"));
            new Printer(session.getFactory()).toString(session.getEntitiesByKey().values().iterator());
        }
    }

    private void prepareEntityFlushes(SessionEventSource session) throws HibernateException {
        Map.Entry[] list = IdentityMap.concurrentEntries(session.getEntityEntries());
        int size = list.length;
        for (int i = 0; i < size; ++i) {
            Map.Entry me = list[i];
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.getStatus();
            if (status != Status.MANAGED && status != Status.SAVING) continue;
            this.cascadeOnFlush(session, entry.getPersister(), me.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnFlush(SessionEventSource session, EntityPersister persister, Object object) throws HibernateException {
        session.incrementCascadeLevel();
        try {
            Cascades.cascade((SessionImplementor)session, (EntityPersister)persister, (Object)object, (Cascades.CascadingAction)this.getCascadingAction(), (int)0, (Object)this.getAnything());
        }
        finally {
            session.decrementCascadeLevel();
        }
    }

    protected Object getAnything() {
        return null;
    }

    protected Cascades.CascadingAction getCascadingAction() {
        return Cascades.ACTION_SAVE_UPDATE;
    }

    private void prepareCollectionFlushes(SessionEventSource session) throws HibernateException {
        List list = IdentityMap.entries(session.getCollectionEntries());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map.Entry e = (Map.Entry)list.get(i);
            ((CollectionEntry)e.getValue()).preFlush((PersistentCollection)e.getKey());
        }
    }

    private void flushEntities(FlushEvent event) throws HibernateException {
        log.trace((Object)"Flushing entities and processing referenced collections");
        SessionEventSource source = event.getSource();
        Map.Entry[] list = IdentityMap.concurrentEntries(source.getEntityEntries());
        int size = list.length;
        for (int i = 0; i < size; ++i) {
            Map.Entry me = list[i];
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.getStatus();
            if (status == Status.LOADING || status == Status.GONE) continue;
            FlushEntityEvent entityEvent = new FlushEntityEvent(source, me.getKey(), entry);
            source.getListeners().getFlushEntityEventListener().onFlushEntity(entityEvent);
        }
        source.getActionQueue().sortUpdateActions();
    }

    private void flushCollections(SessionEventSource session) throws HibernateException {
        Map.Entry me;
        int i;
        log.trace((Object)"Processing unreferenced collections");
        List list = IdentityMap.entries(session.getCollectionEntries());
        int size = list.size();
        for (i = 0; i < size; ++i) {
            me = (Map.Entry)list.get(i);
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.isReached() || ce.isIgnore()) continue;
            Collections.updateUnreachableCollection((PersistentCollection)((PersistentCollection)me.getKey()), (SessionEventSource)session);
        }
        log.trace((Object)"Scheduling collection removes/(re)creates/updates");
        list = IdentityMap.entries(session.getCollectionEntries());
        size = list.size();
        for (i = 0; i < size; ++i) {
            me = (Map.Entry)list.get(i);
            PersistentCollection coll = (PersistentCollection)me.getKey();
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.isDorecreate()) {
                session.getActionQueue().addAction(new CollectionRecreateAction(coll, ce.getCurrentPersister(), ce.getCurrentKey(), (SessionImplementor)session));
            }
            if (ce.isDoremove()) {
                session.getActionQueue().addAction(new CollectionRemoveAction(ce.getLoadedPersister(), ce.getLoadedKey(), ce.snapshotIsEmpty(), (SessionImplementor)session));
            }
            if (!ce.isDoupdate()) continue;
            session.getActionQueue().addAction(new CollectionUpdateAction(coll, ce.getLoadedPersister(), ce.getLoadedKey(), ce.snapshotIsEmpty(), (SessionImplementor)session));
        }
        session.getActionQueue().sortCollectionActions();
    }

    protected void performExecutions(SessionEventSource session) throws HibernateException {
        log.trace((Object)"executing flush");
        try {
            session.getActionQueue().prepareActions();
            session.getActionQueue().executeActions();
        }
        catch (HibernateException he) {
            log.error((Object)"Could not synchronize database state with session", (Throwable)he);
            throw he;
        }
    }

    protected void postFlush(SessionEventSource session) throws HibernateException {
        log.trace((Object)"post flush");
        session.getCollectionsByKey().clear();
        session.clearSubqueries();
        Iterator iter = session.getCollectionEntries().entrySet().iterator();
        while (iter.hasNext()) {
            PersistentCollection pc;
            Map.Entry me = iter.next();
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.postFlush(pc = (PersistentCollection)me.getKey())) {
                iter.remove();
                continue;
            }
            if (!ce.isReached()) continue;
            session.getCollectionsByKey().put(new CollectionKey(ce.getCurrentPersister(), ce.getCurrentKey()), pc);
        }
        session.getInterceptor().postFlush(session.getEntitiesByKey().values().iterator());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

