/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.AbstractEventListener;
import org.hibernate.event.EvictEvent;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.EvictVisitor;
import org.hibernate.event.SessionEventSource;
import org.hibernate.impl.EntityEntry;
import org.hibernate.persister.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class DefaultEvictEventListener
extends AbstractEventListener
implements EvictEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$DefaultEvictEventListener == null ? (class$org$hibernate$event$DefaultEvictEventListener = DefaultEvictEventListener.class$("org.hibernate.event.DefaultEvictEventListener")) : class$org$hibernate$event$DefaultEvictEventListener));
    static /* synthetic */ Class class$org$hibernate$event$DefaultEvictEventListener;

    public void onEvict(EvictEvent event) throws HibernateException {
        SessionEventSource source = event.getSource();
        Object object = event.getObject();
        if (object instanceof HibernateProxy) {
            Object entity;
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            Serializable id = li.getIdentifier();
            EntityPersister persister = source.getFactory().getEntityPersister(li.getEntityName());
            EntityKey key = new EntityKey(id, persister);
            source.removeProxy(key);
            if (!li.isUninitialized() && (entity = source.removeEntity(key)) != null) {
                EntityEntry e = event.getSource().removeEntry(entity);
                this.doEvict(entity, key, e.getPersister(), event.getSource());
            }
        } else {
            EntityEntry e = source.removeEntry(object);
            if (e != null) {
                EntityKey key = new EntityKey(e.getId(), e.getPersister());
                source.removeEntity(key);
                this.doEvict(object, key, e.getPersister(), source);
            }
        }
    }

    protected void doEvict(Object object, EntityKey key, EntityPersister persister, SessionEventSource session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("evicting " + MessageHelper.infoString((EntityPersister)persister)));
        }
        if (persister.hasCollections()) {
            new EvictVisitor(session).process(object, persister);
        }
        session.removeDatabaseSnapshot(key);
        Cascades.cascade((SessionImplementor)session, (EntityPersister)persister, (Object)object, (Cascades.CascadingAction)Cascades.ACTION_EVICT, (int)0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

